/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ws;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.internal.PartImpl;
import org.sonar.api.server.ws.internal.ValidatingRequest;
import org.sonar.api.utils.log.Loggers;

public class ServletRequest
extends ValidatingRequest {
    private final HttpServletRequest source;
    static final Map<String, String> SUPPORTED_MEDIA_TYPES_BY_URL_SUFFIX = ImmutableMap.of((Object)"json", (Object)"application/json", (Object)"protobuf", (Object)"application/x-protobuf", (Object)"text", (Object)"text/plain");

    public ServletRequest(HttpServletRequest source) {
        this.source = source;
    }

    public String method() {
        return this.source.getMethod();
    }

    public String getMediaType() {
        return (String)MoreObjects.firstNonNull((Object)ServletRequest.mediaTypeFromUrl(this.source.getRequestURI()), (Object)MoreObjects.firstNonNull((Object)this.acceptedContentTypeInResponse(), (Object)"application/octet-stream"));
    }

    public boolean hasParam(String key) {
        return this.source.getParameterMap().containsKey(key);
    }

    protected String readParam(String key) {
        return this.source.getParameter(key);
    }

    protected List<String> readMultiParam(String key) {
        Object[] values = this.source.getParameterValues(key);
        return values == null ? Collections.emptyList() : ImmutableList.copyOf((Object[])values);
    }

    protected InputStream readInputStreamParam(String key) {
        Request.Part part = this.readPart(key);
        return part == null ? null : part.getInputStream();
    }

    @CheckForNull
    public Request.Part readPart(String key) {
        try {
            if (!this.isMultipartContent()) {
                return null;
            }
            Part part = this.source.getPart(key);
            if (part == null || part.getSize() == 0L) {
                return null;
            }
            return new PartImpl(part.getInputStream(), part.getSubmittedFileName());
        }
        catch (Exception e) {
            Loggers.get(ServletRequest.class).warn("Can't read file part for parameter " + key, (Throwable)e);
            return null;
        }
    }

    private boolean isMultipartContent() {
        String contentType = this.source.getContentType();
        return contentType != null && contentType.toLowerCase(Locale.ENGLISH).startsWith("multipart/");
    }

    public String toString() {
        StringBuffer url = this.source.getRequestURL();
        String query = this.source.getQueryString();
        if (query != null) {
            url.append("?").append(query);
        }
        return url.toString();
    }

    @CheckForNull
    private String acceptedContentTypeInResponse() {
        return this.source.getHeader("Accept");
    }

    @CheckForNull
    private static String mediaTypeFromUrl(String url) {
        String formatSuffix = StringUtils.substringAfterLast((String)url, (String)".");
        return SUPPORTED_MEDIA_TYPES_BY_URL_SUFFIX.get(formatSuffix.toLowerCase(Locale.ENGLISH));
    }

    public String getPath() {
        return this.source.getRequestURI().replaceFirst(this.source.getContextPath(), "");
    }

    public Optional<String> header(String name) {
        return Optional.ofNullable(this.source.getHeader(name));
    }
}

