/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.webhook.WebHooks;
import org.sonar.server.webhook.Webhook;
import org.sonar.server.webhook.WebhookCaller;
import org.sonar.server.webhook.WebhookDelivery;
import org.sonar.server.webhook.WebhookDeliveryStorage;
import org.sonar.server.webhook.WebhookPayload;

public class WebHooksImpl
implements WebHooks {
    private static final Logger LOGGER = Loggers.get(WebHooksImpl.class);
    private static final String WEBHOOK_PROPERTY_FORMAT = "%s.%s";
    private final WebhookCaller caller;
    private final WebhookDeliveryStorage deliveryStorage;

    public WebHooksImpl(WebhookCaller caller, WebhookDeliveryStorage deliveryStorage) {
        this.caller = caller;
        this.deliveryStorage = deliveryStorage;
    }

    @Override
    public boolean isEnabled(Configuration config) {
        return WebHooksImpl.readWebHooksFrom(config).findAny().isPresent();
    }

    private static Stream<NameUrl> readWebHooksFrom(Configuration config) {
        return Stream.concat(WebHooksImpl.getWebhookProperties(config, "sonar.webhooks.global").stream(), WebHooksImpl.getWebhookProperties(config, "sonar.webhooks.project").stream()).map(webHookProperty -> {
            String name = config.get(String.format(WEBHOOK_PROPERTY_FORMAT, webHookProperty, "name")).orElse(null);
            String url = config.get(String.format(WEBHOOK_PROPERTY_FORMAT, webHookProperty, "url")).orElse(null);
            if (name == null || url == null) {
                return null;
            }
            return new NameUrl(name, url);
        }).filter(Objects::nonNull);
    }

    private static List<String> getWebhookProperties(Configuration config, String propertyKey) {
        String[] webhookIds = config.getStringArray(propertyKey);
        return (List)Arrays.stream(webhookIds).map(webhookId -> String.format(WEBHOOK_PROPERTY_FORMAT, propertyKey, webhookId)).limit(10L).collect(MoreCollectors.toList((int)webhookIds.length));
    }

    @Override
    public void sendProjectAnalysisUpdate(Configuration config, WebHooks.Analysis analysis, Supplier<WebhookPayload> payloadSupplier) {
        List webhooks = (List)WebHooksImpl.readWebHooksFrom(config).map(nameUrl -> new Webhook(analysis.getProjectUuid(), analysis.getCeTaskUuid(), analysis.getAnalysisUuid(), nameUrl.getName(), nameUrl.getUrl())).collect(MoreCollectors.toList());
        if (webhooks.isEmpty()) {
            return;
        }
        WebhookPayload payload = payloadSupplier.get();
        webhooks.forEach(webhook -> {
            WebhookDelivery delivery = this.caller.call((Webhook)webhook, payload);
            WebHooksImpl.log(delivery);
            this.deliveryStorage.persist(delivery);
        });
        this.deliveryStorage.purge(analysis.getProjectUuid());
    }

    private static void log(WebhookDelivery delivery) {
        Optional<String> error = delivery.getErrorMessage();
        if (error.isPresent()) {
            LOGGER.debug("Failed to send webhook '{}' | url={} | message={}", new Object[]{delivery.getWebhook().getName(), delivery.getWebhook().getUrl(), error.get()});
        } else {
            LOGGER.debug("Sent webhook '{}' | url={} | time={}ms | status={}", new Object[]{delivery.getWebhook().getName(), delivery.getWebhook().getUrl(), delivery.getDurationInMs().orElse(-1), delivery.getHttpStatus().orElse(-1)});
        }
    }

    private static final class NameUrl {
        private final String name;
        private final String url;

        private NameUrl(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

