/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;
import org.sonar.server.webhook.WebhookPayload;

public interface WebHooks {
    public boolean isEnabled(Configuration var1);

    public void sendProjectAnalysisUpdate(Configuration var1, Analysis var2, Supplier<WebhookPayload> var3);

    public static final class Analysis {
        private final String projectUuid;
        private final String ceTaskUuid;
        private final String analysisUuid;

        public Analysis(String projectUuid, @Nullable String analysisUuid, @Nullable String ceTaskUuid) {
            this.projectUuid = Objects.requireNonNull(projectUuid, "projectUuid can't be null");
            this.analysisUuid = analysisUuid;
            this.ceTaskUuid = ceTaskUuid;
        }

        public String getProjectUuid() {
            return this.projectUuid;
        }

        @CheckForNull
        public String getCeTaskUuid() {
            return this.ceTaskUuid;
        }

        @CheckForNull
        public String getAnalysisUuid() {
            return this.analysisUuid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Analysis analysis = (Analysis)o;
            return Objects.equals(this.projectUuid, analysis.projectUuid) && Objects.equals(this.ceTaskUuid, analysis.ceTaskUuid) && Objects.equals(this.analysisUuid, analysis.analysisUuid);
        }

        public int hashCode() {
            return Objects.hash(this.projectUuid, this.ceTaskUuid, this.analysisUuid);
        }

        public String toString() {
            return "Analysis{projectUuid='" + this.projectUuid + '\'' + ", ceTaskUuid='" + this.ceTaskUuid + '\'' + '}';
        }
    }
}

