/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook;

import java.util.Objects;

public final class Project {
    private final String uuid;
    private final String key;
    private final String name;

    public Project(String uuid, String key, String name) {
        this.uuid = Objects.requireNonNull(uuid, "uuid can't be null");
        this.key = Objects.requireNonNull(key, "key can't be null");
        this.name = Objects.requireNonNull(name, "name can't be null");
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Project project = (Project)o;
        return Objects.equals(this.uuid, project.uuid) && Objects.equals(this.key, project.key) && Objects.equals(this.name, project.name);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.key, this.name);
    }

    public String toString() {
        return "Project{uuid='" + this.uuid + '\'' + ", key='" + this.key + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

