/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usertoken.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.server.user.UserSession;
import org.sonar.server.usertoken.ws.TokenPermissionsValidator;
import org.sonar.server.usertoken.ws.UserTokensWsAction;
import org.sonarqube.ws.client.usertoken.RevokeWsRequest;

public class RevokeAction
implements UserTokensWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;

    public RevokeAction(DbClient dbClient, UserSession userSession) {
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("revoke").setDescription("Revoke a user access token. <br/>If the login is set, it requires administration permissions. Otherwise, a token is generated for the authenticated user.").setSince("5.3").setPost(true).setHandler((RequestHandler)this);
        action.createParam("login").setDescription("User login").setExampleValue((Object)"g.hopper");
        action.createParam("name").setRequired(true).setDescription("Token name").setExampleValue((Object)"Project scan on Travis");
    }

    public void handle(Request request, Response response) throws Exception {
        this.doHandle(this.toRevokeWsRequest(request));
        response.noContent();
    }

    private void doHandle(RevokeWsRequest request) {
        TokenPermissionsValidator.validate(this.userSession, request.getLogin());
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.dbClient.userTokenDao().deleteByLoginAndName(dbSession, request.getLogin(), request.getName());
            dbSession.commit();
        }
    }

    private RevokeWsRequest toRevokeWsRequest(Request request) {
        RevokeWsRequest revokeWsRequest = new RevokeWsRequest().setLogin(request.param("login")).setName(request.mandatoryParam("name"));
        if (revokeWsRequest.getLogin() == null) {
            revokeWsRequest.setLogin(this.userSession.getLogin());
        }
        return revokeWsRequest;
    }
}

