/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usergroups.ws;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.sonar.db.user.GroupDto;

@Immutable
public class GroupId {
    private final int id;
    private final String organizationUuid;

    private GroupId(String organizationUuid, int id) {
        this.id = id;
        this.organizationUuid = Objects.requireNonNull(organizationUuid);
    }

    public int getId() {
        return this.id;
    }

    public String getOrganizationUuid() {
        return this.organizationUuid;
    }

    public static GroupId from(GroupDto dto) {
        return new GroupId(dto.getOrganizationUuid(), dto.getId());
    }
}

