/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.index;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.index.IndexRequest;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.es.EsQueueDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.es.BulkIndexer;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.IndexingListener;
import org.sonar.server.es.IndexingResult;
import org.sonar.server.es.OneToOneResilientIndexingListener;
import org.sonar.server.es.ResilientIndexer;
import org.sonar.server.user.index.UserDoc;
import org.sonar.server.user.index.UserIndexDefinition;

public class UserIndexer
implements ResilientIndexer {
    private final DbClient dbClient;
    private final EsClient esClient;

    public UserIndexer(DbClient dbClient, EsClient esClient) {
        this.dbClient = dbClient;
        this.esClient = esClient;
    }

    @Override
    public Set<IndexType> getIndexTypes() {
        return ImmutableSet.of((Object)UserIndexDefinition.INDEX_TYPE_USER);
    }

    @Override
    public void indexOnStartup(Set<IndexType> uninitializedIndexTypes) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ArrayListMultimap organizationUuidsByLogin = ArrayListMultimap.create();
            this.dbClient.organizationMemberDao().selectAllForUserIndexing(dbSession, (arg_0, arg_1) -> ((ListMultimap)organizationUuidsByLogin).put(arg_0, arg_1));
            BulkIndexer bulkIndexer = this.newBulkIndexer(BulkIndexer.Size.LARGE, IndexingListener.FAIL_ON_ERROR);
            bulkIndexer.start();
            this.dbClient.userDao().scrollAll(dbSession, arg_0 -> UserIndexer.lambda$indexOnStartup$0(bulkIndexer, (ListMultimap)organizationUuidsByLogin, arg_0));
            bulkIndexer.stop();
        }
    }

    public void commitAndIndex(DbSession dbSession, UserDto user) {
        this.commitAndIndexByLogins(dbSession, Collections.singletonList(user.getLogin()));
    }

    public void commitAndIndex(DbSession dbSession, Collection<UserDto> users) {
        this.commitAndIndexByLogins(dbSession, Collections2.transform(users, UserDto::getLogin));
    }

    public void commitAndIndexByLogins(DbSession dbSession, Collection<String> logins) {
        List items = (List)logins.stream().map(l -> EsQueueDto.create((String)UserIndexDefinition.INDEX_TYPE_USER.format(), (String)l)).collect(MoreCollectors.toArrayList());
        this.dbClient.esQueueDao().insert(dbSession, (Collection)items);
        dbSession.commit();
        this.postCommit(dbSession, logins, items);
    }

    private void postCommit(DbSession dbSession, Collection<String> logins, Collection<EsQueueDto> items) {
        this.index(dbSession, items);
    }

    @Override
    public IndexingResult index(DbSession dbSession, Collection<EsQueueDto> items) {
        if (items.isEmpty()) {
            return new IndexingResult();
        }
        Set logins = (Set)items.stream().map(EsQueueDto::getDocId).collect(MoreCollectors.toHashSet((int)items.size()));
        ArrayListMultimap organizationUuidsByLogin = ArrayListMultimap.create();
        this.dbClient.organizationMemberDao().selectForUserIndexing(dbSession, (Collection)logins, (arg_0, arg_1) -> ((ListMultimap)organizationUuidsByLogin).put(arg_0, arg_1));
        BulkIndexer bulkIndexer = this.newBulkIndexer(BulkIndexer.Size.REGULAR, new OneToOneResilientIndexingListener(this.dbClient, dbSession, items));
        bulkIndexer.start();
        this.dbClient.userDao().scrollByLogins(dbSession, (Collection)logins, arg_0 -> UserIndexer.lambda$index$2(logins, bulkIndexer, (ListMultimap)organizationUuidsByLogin, arg_0));
        logins.forEach(l -> bulkIndexer.addDeletion(UserIndexDefinition.INDEX_TYPE_USER, (String)l));
        return bulkIndexer.stop();
    }

    private BulkIndexer newBulkIndexer(BulkIndexer.Size bulkSize, IndexingListener listener) {
        return new BulkIndexer(this.esClient, UserIndexDefinition.INDEX_TYPE_USER, bulkSize, listener);
    }

    private static IndexRequest newIndexRequest(UserDto user, ListMultimap<String, String> organizationUuidsByLogins) {
        UserDoc doc = new UserDoc(Maps.newHashMapWithExpectedSize((int)8));
        doc.setLogin(user.getLogin());
        doc.setName(user.getName());
        doc.setEmail(user.getEmail());
        doc.setActive(user.isActive());
        doc.setScmAccounts(UserDto.decodeScmAccounts((String)user.getScmAccounts()));
        doc.setOrganizationUuids(organizationUuidsByLogins.get((Object)user.getLogin()));
        return new IndexRequest(UserIndexDefinition.INDEX_TYPE_USER.getIndex(), UserIndexDefinition.INDEX_TYPE_USER.getType()).id(doc.getId()).routing(doc.getRouting()).source(doc.getFields());
    }

    private static /* synthetic */ void lambda$index$2(Set logins, BulkIndexer bulkIndexer, ListMultimap organizationUuidsByLogin, UserDto u) {
        logins.remove(u.getLogin());
        bulkIndexer.add(UserIndexer.newIndexRequest(u, (ListMultimap<String, String>)organizationUuidsByLogin));
    }

    private static /* synthetic */ void lambda$indexOnStartup$0(BulkIndexer bulkIndexer, ListMultimap organizationUuidsByLogin, UserDto u) {
        bulkIndexer.add(UserIndexer.newIndexRequest(u, (ListMultimap<String, String>)organizationUuidsByLogin));
    }
}

