/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user;

import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.security.LoginPasswordAuthenticator;
import org.sonar.api.security.SecurityRealm;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.user.CompatibilityRealm;

@ServerSide
public class SecurityRealmFactory
implements Startable {
    private final boolean ignoreStartupFailure;
    private final SecurityRealm realm;

    public SecurityRealmFactory(Configuration config, SecurityRealm[] realms, LoginPasswordAuthenticator[] authenticators) {
        this.ignoreStartupFailure = config.getBoolean("sonar.authenticator.ignoreStartupFailure").orElse(false);
        String realmName = config.get("sonar.security.realm").orElse(null);
        String className = config.get("sonar.authenticator.class").orElse(null);
        SecurityRealm selectedRealm = null;
        if (!StringUtils.isEmpty((String)realmName) && (selectedRealm = SecurityRealmFactory.selectRealm(realms, realmName)) == null) {
            throw new SonarException(String.format("Realm '%s' not found. Please check the property '%s' in conf/sonar.properties", realmName, "sonar.security.realm"));
        }
        if (selectedRealm == null && !StringUtils.isEmpty((String)className)) {
            LoginPasswordAuthenticator authenticator = SecurityRealmFactory.selectAuthenticator(authenticators, className);
            if (authenticator == null) {
                throw new SonarException(String.format("Authenticator '%s' not found. Please check the property '%s' in conf/sonar.properties", className, "sonar.authenticator.class"));
            }
            selectedRealm = new CompatibilityRealm(authenticator);
        }
        this.realm = selectedRealm;
    }

    public SecurityRealmFactory(Configuration config, LoginPasswordAuthenticator[] authenticators) {
        this(config, new SecurityRealm[0], authenticators);
    }

    public SecurityRealmFactory(Configuration config, SecurityRealm[] realms) {
        this(config, realms, new LoginPasswordAuthenticator[0]);
    }

    public SecurityRealmFactory(Configuration config) {
        this(config, new SecurityRealm[0], new LoginPasswordAuthenticator[0]);
    }

    public void start() {
        if (this.realm != null) {
            Logger logger = Loggers.get((String)"org.sonar.INFO");
            try {
                logger.info("Security realm: " + this.realm.getName());
                this.realm.init();
                logger.info("Security realm started");
            }
            catch (RuntimeException e) {
                if (this.ignoreStartupFailure) {
                    logger.error("IGNORED - Security realm fails to start: " + e.getMessage());
                }
                throw new SonarException("Security realm fails to start: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void stop() {
    }

    @Nullable
    public SecurityRealm getRealm() {
        return this.realm;
    }

    public boolean hasExternalAuthentication() {
        return this.getRealm() != null;
    }

    private static SecurityRealm selectRealm(SecurityRealm[] realms, String realmName) {
        for (SecurityRealm realm : realms) {
            if (!StringUtils.equals((String)realmName, (String)realm.getName())) continue;
            return realm;
        }
        return null;
    }

    private static LoginPasswordAuthenticator selectAuthenticator(LoginPasswordAuthenticator[] authenticators, String className) {
        for (LoginPasswordAuthenticator lpa : authenticators) {
            if (!lpa.getClass().getName().equals(className)) continue;
            return lpa;
        }
        return null;
    }
}

