/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.settings;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.Settings;
import org.sonar.api.config.internal.ConfigurationBridge;

public class ChildSettings
extends Settings {
    private final Settings parentSettings;
    private final Map<String, String> localProperties = new HashMap<String, String>();

    public ChildSettings(Settings parentSettings) {
        super(parentSettings.getDefinitions(), parentSettings.getEncryption());
        this.parentSettings = parentSettings;
    }

    protected Optional<String> get(String key) {
        String value = this.localProperties.get(key);
        if (value != null) {
            return Optional.of(value);
        }
        return this.parentSettings.getRawString(key);
    }

    protected void set(String key, String value) {
        this.localProperties.put(Objects.requireNonNull(key, "key can't be null"), Objects.requireNonNull(value, "value can't be null").trim());
    }

    protected void remove(String key) {
        this.localProperties.remove(key);
    }

    public Map<String, String> getProperties() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(this.parentSettings.getProperties());
        builder.putAll(this.localProperties);
        return builder.build();
    }

    public Configuration asConfiguration() {
        return new ConfigurationBridge((Settings)this);
    }
}

