/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.setting.ws;

import com.google.common.base.Splitter;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.property.PropertyDto;
import org.sonar.server.setting.ws.PropertySetExtractor;
import org.sonar.server.setting.ws.Setting;

public class SettingsFinder {
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".").omitEmptyStrings();
    private final DbClient dbClient;
    private final PropertyDefinitions definitions;

    public SettingsFinder(DbClient dbClient, PropertyDefinitions definitions) {
        this.dbClient = dbClient;
        this.definitions = definitions;
    }

    public List<Setting> loadGlobalSettings(DbSession dbSession, Set<String> keys) {
        List properties = this.dbClient.propertiesDao().selectGlobalPropertiesByKeys(dbSession, keys);
        List propertySets = this.dbClient.propertiesDao().selectGlobalPropertiesByKeys(dbSession, this.getPropertySetKeys(properties));
        return properties.stream().map(property -> Setting.createFromDto(property, SettingsFinder.getPropertySets(property.getKey(), propertySets, null), this.definitions.get(property.getKey()))).collect(Collectors.toList());
    }

    public Multimap<String, Setting> loadComponentSettings(DbSession dbSession, Set<String> keys, ComponentDto component) {
        List componentUuids = DOT_SPLITTER.splitToList((CharSequence)component.moduleUuidPath());
        List componentDtos = this.dbClient.componentDao().selectByUuids(dbSession, (Collection)componentUuids);
        Set componentIds = componentDtos.stream().map(ComponentDto::getId).collect(Collectors.toSet());
        Map<Long, String> uuidsById = componentDtos.stream().collect(Collectors.toMap(ComponentDto::getId, ComponentDto::uuid));
        List properties = this.dbClient.propertiesDao().selectPropertiesByKeysAndComponentIds(dbSession, keys, componentIds);
        List propertySets = this.dbClient.propertiesDao().selectPropertiesByKeysAndComponentIds(dbSession, this.getPropertySetKeys(properties), componentIds);
        TreeMultimap settingsByUuid = TreeMultimap.create((Comparator)Ordering.explicit((List)componentUuids), (Comparator)Ordering.arbitrary());
        for (PropertyDto propertyDto : properties) {
            Long componentId = propertyDto.getResourceId();
            String componentUuid = uuidsById.get(componentId);
            String propertyKey = propertyDto.getKey();
            settingsByUuid.put((Object)componentUuid, (Object)Setting.createFromDto(propertyDto, SettingsFinder.getPropertySets(propertyKey, propertySets, componentId), this.definitions.get(propertyKey)));
        }
        return settingsByUuid;
    }

    private Set<String> getPropertySetKeys(List<PropertyDto> properties) {
        return properties.stream().filter(propertyDto -> this.definitions.get(propertyDto.getKey()) != null).filter(propertyDto -> this.definitions.get(propertyDto.getKey()).type().equals((Object)PropertyType.PROPERTY_SET)).flatMap(propertyDto -> PropertySetExtractor.extractPropertySetKeys(propertyDto, this.definitions.get(propertyDto.getKey())).stream()).collect(Collectors.toSet());
    }

    private static List<PropertyDto> getPropertySets(String propertyKey, List<PropertyDto> propertySets, @Nullable Long componentId) {
        return propertySets.stream().filter(propertyDto -> Objects.equals(propertyDto.getResourceId(), componentId)).filter(propertyDto -> propertyDto.getKey().startsWith(propertyKey + ".")).collect(Collectors.toList());
    }
}

