/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.setting.ws;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.i18n.I18n;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.ws.WsUtils;

public class SettingValidations {
    private final PropertyDefinitions definitions;
    private final DbClient dbClient;
    private final I18n i18n;
    private static final Set<String> SUPPORTED_QUALIFIERS = ImmutableSet.of((Object)"TRK", (Object)"VW", (Object)"APP", (Object)"BRC", (Object)"SVW");

    public SettingValidations(PropertyDefinitions definitions, DbClient dbClient, I18n i18n) {
        this.definitions = definitions;
        this.dbClient = dbClient;
        this.i18n = i18n;
    }

    public Consumer<SettingData> scope() {
        return data -> {
            PropertyDefinition definition = this.definitions.get(((SettingData)data).key);
            WsUtils.checkRequest(((SettingData)data).component != null || definition == null || definition.global() || SettingValidations.isGlobal(definition), "Setting '%s' cannot be global", ((SettingData)data).key);
        };
    }

    public Consumer<SettingData> qualifier() {
        return data -> {
            String qualifier = ((SettingData)data).component == null ? "" : ((SettingData)data).component.qualifier();
            PropertyDefinition definition = this.definitions.get(((SettingData)data).key);
            WsUtils.checkRequest(SettingValidations.checkComponentScopeAndQualifier(data, definition), "Setting '%s' cannot be set on a %s", ((SettingData)data).key, this.i18n.message(Locale.ENGLISH, "qualifier." + qualifier, null, new Object[0]));
        };
    }

    private static boolean checkComponentScopeAndQualifier(SettingData data, @Nullable PropertyDefinition definition) {
        ComponentDto component = data.component;
        if (component == null) {
            return true;
        }
        if (!"PRJ".equals(component.scope())) {
            return false;
        }
        if (definition == null) {
            return SUPPORTED_QUALIFIERS.contains(component.qualifier());
        }
        return definition.qualifiers().contains(component.qualifier());
    }

    public Consumer<SettingData> valueType() {
        return new ValueTypeValidation();
    }

    private static boolean isGlobal(PropertyDefinition definition) {
        return !definition.global() && definition.qualifiers().isEmpty();
    }

    private class ValueTypeValidation
    implements Consumer<SettingData> {
        private ValueTypeValidation() {
        }

        @Override
        public void accept(SettingData data) {
            PropertyDefinition definition = SettingValidations.this.definitions.get(data.key);
            if (definition == null) {
                return;
            }
            if (definition.type() == PropertyType.METRIC) {
                this.validateMetric(data);
            } else if (definition.type() == PropertyType.USER_LOGIN) {
                this.validateLogin(data);
            } else {
                this.validateOtherTypes(data, definition);
            }
        }

        private void validateOtherTypes(SettingData data, PropertyDefinition definition) {
            data.values.stream().map(arg_0 -> ((PropertyDefinition)definition).validate(arg_0)).filter(result -> !result.isValid()).findAny().ifPresent(result -> {
                throw BadRequestException.create(SettingValidations.this.i18n.message(Locale.ENGLISH, "property.error." + result.getErrorKey(), String.format("Error when validating setting with key '%s' and value [%s]", data.key, data.values.stream().collect(Collectors.joining(", "))), new Object[0]));
            });
        }

        private void validateMetric(SettingData data) {
            try (DbSession dbSession = SettingValidations.this.dbClient.openSession(false);){
                List metrics = SettingValidations.this.dbClient.metricDao().selectByKeys(dbSession, data.values).stream().filter(MetricDto::isEnabled).collect(Collectors.toList());
                WsUtils.checkRequest(data.values.size() == metrics.size(), "Error when validating metric setting with key '%s' and values [%s]. A value is not a valid metric key.", data.key, data.values.stream().collect(Collectors.joining(", ")));
            }
        }

        private void validateLogin(SettingData data) {
            try (DbSession dbSession = SettingValidations.this.dbClient.openSession(false);){
                List users = SettingValidations.this.dbClient.userDao().selectByLogins(dbSession, (Collection)data.values).stream().filter(UserDto::isActive).collect(Collectors.toList());
                WsUtils.checkRequest(data.values.size() == users.size(), "Error when validating login setting with key '%s' and values [%s]. A value is not a valid login.", data.key, data.values.stream().collect(Collectors.joining(", ")));
            }
        }
    }

    static class SettingData {
        private final String key;
        private final List<String> values;
        @CheckForNull
        private final ComponentDto component;

        SettingData(String key, List<String> values, @Nullable ComponentDto component) {
            this.key = Objects.requireNonNull(key);
            this.values = Objects.requireNonNull(values);
            this.component = component;
        }
    }
}

