/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.setting.ws;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.config.PropertyFieldDefinition;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.property.PropertyDto;
import org.sonar.scanner.protocol.GsonHelper;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.platform.SettingsChangeNotifier;
import org.sonar.server.setting.ws.SettingValidations;
import org.sonar.server.setting.ws.SettingsUpdater;
import org.sonar.server.setting.ws.SettingsWs;
import org.sonar.server.setting.ws.SettingsWsAction;
import org.sonar.server.setting.ws.SettingsWsSupport;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.client.setting.SetRequest;

public class SetAction
implements SettingsWsAction {
    private static final Collector<CharSequence, ?, String> COMMA_JOINER = Collectors.joining(",");
    private static final String MSG_NO_EMPTY_VALUE = "A non empty value must be provided";
    private final PropertyDefinitions propertyDefinitions;
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final UserSession userSession;
    private final SettingsUpdater settingsUpdater;
    private final SettingsChangeNotifier settingsChangeNotifier;
    private final SettingValidations validations;
    private final SettingsWsSupport settingsWsSupport;

    public SetAction(PropertyDefinitions propertyDefinitions, DbClient dbClient, ComponentFinder componentFinder, UserSession userSession, SettingsUpdater settingsUpdater, SettingsChangeNotifier settingsChangeNotifier, SettingValidations validations, SettingsWsSupport settingsWsSupport) {
        this.propertyDefinitions = propertyDefinitions;
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.userSession = userSession;
        this.settingsUpdater = settingsUpdater;
        this.settingsChangeNotifier = settingsChangeNotifier;
        this.validations = validations;
        this.settingsWsSupport = settingsWsSupport;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("set").setDescription("Update a setting value.<br>Either '%s' or '%s' must be provided.<br> Requires one of the following permissions: <ul><li>'Administer System'</li><li>'Administer' rights on the specified component</li></ul>", new Object[]{"value", "values"}).setSince("6.1").setPost(true).setHandler((RequestHandler)this);
        action.createParam("key").setDescription("Setting key").setExampleValue((Object)"sonar.links.scm").setRequired(true);
        action.createParam("value").setDescription("Setting value. To reset a value, please use the reset web service.").setExampleValue((Object)"git@github.com:SonarSource/sonarqube.git");
        action.createParam("values").setDescription("Setting multi value. To set several values, the parameter must be called once for each value.").setExampleValue((Object)"values=firstValue&values=secondValue&values=thirdValue");
        action.createParam("fieldValues").setDescription("Setting field values. To set several values, the parameter must be called once for each value.").setExampleValue((Object)"fieldValues={\"firstField\":\"first value\", \"secondField\":\"second value\", \"thirdField\":\"third value\"}");
        action.createParam("component").setDescription("Component key").setDeprecatedKey("componentKey", "6.3").setExampleValue((Object)"my_project");
        this.settingsWsSupport.addBranchParam(action);
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.doHandle(dbSession, SetAction.toWsRequest(request));
        }
        response.noContent();
    }

    private void doHandle(DbSession dbSession, SetRequest request) {
        String value;
        Optional<ComponentDto> component = this.searchComponent(dbSession, request);
        this.checkPermissions(component);
        PropertyDefinition definition = this.propertyDefinitions.get(request.getKey());
        this.commonChecks(request, component);
        if (!request.getFieldValues().isEmpty()) {
            value = this.doHandlePropertySet(dbSession, request, definition, component);
        } else {
            this.validate(request);
            PropertyDto property = this.toProperty(request, component);
            value = property.getValue();
            this.dbClient.propertiesDao().saveProperty(dbSession, property);
        }
        dbSession.commit();
        if (!component.isPresent()) {
            this.settingsChangeNotifier.onGlobalPropertyChange(this.persistedKey(request), value);
        }
    }

    private String doHandlePropertySet(DbSession dbSession, SetRequest request, @Nullable PropertyDefinition definition, Optional<ComponentDto> component) {
        SetAction.validatePropertySet(request, definition);
        int[] fieldIds = IntStream.rangeClosed(1, request.getFieldValues().size()).toArray();
        String inlinedFieldKeys = IntStream.of(fieldIds).mapToObj(String::valueOf).collect(COMMA_JOINER);
        String key = this.persistedKey(request);
        Long componentId = component.isPresent() ? component.get().getId() : null;
        this.deleteSettings(dbSession, component, key);
        this.dbClient.propertiesDao().saveProperty(dbSession, new PropertyDto().setKey(key).setValue(inlinedFieldKeys).setResourceId(componentId));
        List fieldValues = request.getFieldValues();
        IntStream.of(fieldIds).boxed().flatMap(i -> SetAction.readOneFieldValues((String)fieldValues.get(i - 1), request.getKey()).entrySet().stream().map(entry -> new KeyValue(key + "." + i + "." + (String)entry.getKey(), (String)entry.getValue()))).forEach(keyValue -> this.dbClient.propertiesDao().saveProperty(dbSession, SetAction.toFieldProperty(keyValue, componentId)));
        return inlinedFieldKeys;
    }

    private void deleteSettings(DbSession dbSession, Optional<ComponentDto> component, String key) {
        if (component.isPresent()) {
            this.settingsUpdater.deleteComponentSettings(dbSession, component.get(), key);
        } else {
            this.settingsUpdater.deleteGlobalSettings(dbSession, key);
        }
    }

    private void commonChecks(SetRequest request, Optional<ComponentDto> component) {
        SetAction.checkValueIsSet(request);
        String settingKey = request.getKey();
        SettingValidations.SettingData settingData = new SettingValidations.SettingData(settingKey, SetAction.valuesFromRequest(request), component.orElse(null));
        ImmutableList.of(this.validations.scope(), this.validations.qualifier(), this.validations.valueType()).forEach(validation -> validation.accept(settingData));
        component.map(ComponentDto::getBranch).ifPresent(b -> Preconditions.checkArgument((boolean)SettingsWs.SETTING_ON_BRANCHES.contains(settingKey), (Object)String.format("Setting '%s' cannot be set on a branch", settingKey)));
    }

    private static void validatePropertySet(SetRequest request, @Nullable PropertyDefinition definition) {
        WsUtils.checkRequest(definition != null, "Setting '%s' is undefined", request.getKey());
        WsUtils.checkRequest(PropertyType.PROPERTY_SET.equals((Object)definition.type()), "Parameter '%s' is used for setting of property set type only", "fieldValues");
        Set fieldKeys = definition.fields().stream().map(PropertyFieldDefinition::key).collect(Collectors.toSet());
        ArrayListMultimap valuesByFieldKeys = ArrayListMultimap.create((int)fieldKeys.size(), (int)(request.getFieldValues().size() * fieldKeys.size()));
        request.getFieldValues().stream().map(oneFieldValues -> SetAction.readOneFieldValues(oneFieldValues, request.getKey())).peek(map -> WsUtils.checkRequest(map.values().stream().anyMatch(StringUtils::isNotBlank), MSG_NO_EMPTY_VALUE, new Object[0])).flatMap(map -> map.entrySet().stream()).peek(arg_0 -> SetAction.lambda$validatePropertySet$8((ListMultimap)valuesByFieldKeys, arg_0)).forEach(entry -> WsUtils.checkRequest(fieldKeys.contains(entry.getKey()), "Unknown field key '%s' for setting '%s'", entry.getKey(), request.getKey()));
        SetAction.checkFieldType(request, definition, (ListMultimap<String, String>)valuesByFieldKeys);
    }

    private void validate(SetRequest request) {
        PropertyDefinition definition = this.propertyDefinitions.get(request.getKey());
        if (definition == null) {
            return;
        }
        SetAction.checkSingleOrMultiValue(request, definition);
    }

    private static void checkFieldType(SetRequest request, PropertyDefinition definition, ListMultimap<String, String> valuesByFieldKeys) {
        for (PropertyFieldDefinition fieldDefinition : definition.fields()) {
            for (String value : valuesByFieldKeys.get((Object)fieldDefinition.key())) {
                PropertyDefinition.Result result = fieldDefinition.validate(value);
                WsUtils.checkRequest(result.isValid(), "Error when validating setting with key '%s'. Field '%s' has incorrect value '%s'.", request.getKey(), fieldDefinition.key(), value);
            }
        }
    }

    private static void checkSingleOrMultiValue(SetRequest request, PropertyDefinition definition) {
        WsUtils.checkRequest(definition.multiValues() ^ request.getValue() != null, "Parameter '%s' must be used for single value setting. Parameter '%s' must be used for multi value setting.", "value", "values");
    }

    private static void checkValueIsSet(SetRequest request) {
        WsUtils.checkRequest(request.getValue() != null ^ !request.getValues().isEmpty() ^ !request.getFieldValues().isEmpty(), "Either '%s', '%s' or '%s' must be provided", "value", "values", "fieldValues");
        WsUtils.checkRequest(request.getValues().stream().allMatch(StringUtils::isNotBlank), MSG_NO_EMPTY_VALUE, new Object[0]);
        WsUtils.checkRequest(request.getValue() == null || StringUtils.isNotBlank((String)request.getValue()), MSG_NO_EMPTY_VALUE, new Object[0]);
    }

    private static List<String> valuesFromRequest(SetRequest request) {
        return request.getValue() == null ? request.getValues() : Collections.singletonList(request.getValue());
    }

    private String persistedKey(SetRequest request) {
        PropertyDefinition definition = this.propertyDefinitions.get(request.getKey());
        return definition == null ? request.getKey() : definition.key();
    }

    private static String persistedValue(SetRequest request) {
        return request.getValue() == null ? request.getValues().stream().map(value -> value.replace(",", "%2C")).collect(COMMA_JOINER) : request.getValue();
    }

    private void checkPermissions(Optional<ComponentDto> component) {
        if (component.isPresent()) {
            this.userSession.checkComponentPermission("admin", component.get());
        } else {
            this.userSession.checkIsSystemAdministrator();
        }
    }

    private static SetRequest toWsRequest(Request request) {
        return SetRequest.builder().setKey(request.mandatoryParam("key")).setValue(request.param("value")).setValues(request.multiParam("values")).setFieldValues(request.multiParam("fieldValues")).setComponent(request.param("component")).setBranch(request.param("branch")).build();
    }

    private static Map<String, String> readOneFieldValues(String json, String key) {
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        Gson gson = GsonHelper.create();
        try {
            return (Map)gson.fromJson(json, type);
        }
        catch (JsonSyntaxException e) {
            throw BadRequestException.create(String.format("JSON '%s' does not respect expected format for setting '%s'. Ex: {\"field1\":\"value1\", \"field2\":\"value2\"}", json, key));
        }
    }

    private Optional<ComponentDto> searchComponent(DbSession dbSession, SetRequest request) {
        String componentKey = request.getComponent();
        if (componentKey == null) {
            return Optional.empty();
        }
        return Optional.of(this.componentFinder.getByKeyAndOptionalBranch(dbSession, componentKey, request.getBranch()));
    }

    private PropertyDto toProperty(SetRequest request, Optional<ComponentDto> component) {
        String key = this.persistedKey(request);
        String value = SetAction.persistedValue(request);
        PropertyDto property = new PropertyDto().setKey(key).setValue(value);
        if (component.isPresent()) {
            property.setResourceId(component.get().getId());
        }
        return property;
    }

    private static PropertyDto toFieldProperty(KeyValue keyValue, @Nullable Long componentId) {
        return new PropertyDto().setKey(keyValue.key).setValue(keyValue.value).setResourceId(componentId);
    }

    private static /* synthetic */ void lambda$validatePropertySet$8(ListMultimap valuesByFieldKeys, Map.Entry entry) {
        valuesByFieldKeys.put(entry.getKey(), entry.getValue());
    }

    private static class KeyValue {
        private final String key;
        private final String value;

        private KeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

