/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.setting.ws;

import com.google.protobuf.Message;
import org.sonar.api.config.Settings;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.server.setting.ws.SettingsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Settings;

public class CheckSecretKeyAction
implements SettingsWsAction {
    private final Settings settings;
    private final UserSession userSession;

    public CheckSecretKeyAction(Settings settings, UserSession userSession) {
        this.settings = settings;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        context.createAction("check_secret_key").setDescription("Check if a secret key is available.<br>Requires the 'Administer System' permission.").setSince("6.1").setInternal(true).setResponseExample(this.getClass().getResource("check_secret_key-example.json")).setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkIsSystemAdministrator();
        WsUtils.writeProtobuf((Message)Settings.CheckSecretKeyWsResponse.newBuilder().setSecretKeyAvailable(this.settings.getEncryption().hasSecretKey()).build(), request, response);
    }
}

