/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.ws;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rule.Severity;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleDto;
import org.sonar.db.rule.RuleParamDto;
import org.sonar.server.es.Facets;
import org.sonar.server.es.SearchIdResult;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.qualityprofile.ActiveRule;
import org.sonar.server.rule.index.RuleIndex;
import org.sonar.server.rule.index.RuleIndexDefinition;
import org.sonar.server.rule.index.RuleQuery;
import org.sonar.server.rule.ws.ActiveRuleCompleter;
import org.sonar.server.rule.ws.RuleMapper;
import org.sonar.server.rule.ws.RuleQueryFactory;
import org.sonar.server.rule.ws.RulesWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Rules;
import org.sonarqube.ws.client.rule.RulesWsParameters;
import org.sonarqube.ws.client.rule.SearchWsRequest;

public class SearchAction
implements RulesWsAction {
    public static final String ACTION = "search";
    private static final Collection<String> DEFAULT_FACETS = ImmutableSet.of((Object)"languages", (Object)"repositories", (Object)"tags");
    private static final String[] POSSIBLE_FACETS = new String[]{"languages", "repositories", "tags", "severities", "active_severities", "statuses", "types", "true"};
    private final RuleQueryFactory ruleQueryFactory;
    private final DbClient dbClient;
    private final RuleIndex ruleIndex;
    private final ActiveRuleCompleter activeRuleCompleter;
    private final RuleMapper mapper;

    public SearchAction(RuleIndex ruleIndex, ActiveRuleCompleter activeRuleCompleter, RuleQueryFactory ruleQueryFactory, DbClient dbClient, RuleMapper mapper) {
        this.ruleIndex = ruleIndex;
        this.activeRuleCompleter = activeRuleCompleter;
        this.ruleQueryFactory = ruleQueryFactory;
        this.dbClient = dbClient;
        this.mapper = mapper;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction(ACTION).addPagingParams(100, 500).setHandler((RequestHandler)this);
        action.createParam("facets").setDescription("Comma-separated list of the facets to be computed. No facet is computed by default.").setPossibleValues((Object[])POSSIBLE_FACETS).setExampleValue((Object)String.format("%s,%s", POSSIBLE_FACETS[0], POSSIBLE_FACETS[1]));
        WebService.NewParam paramFields = action.createParam("f").setDescription("Comma-separated list of the fields to be returned in response. All the fields are returned by default, except actives.Since 5.5, following fields have been deprecated :<ul><li>\"defaultDebtRemFn\" becomes \"defaultRemFn\"</li><li>\"debtRemFn\" becomes \"remFn\"</li><li>\"effortToFixDescription\" becomes \"gapDescription\"</li><li>\"debtOverloaded\" becomes \"remFnOverloaded\"</li></ul>").setPossibleValues((Collection)Ordering.natural().sortedCopy((Iterable)RulesWsParameters.OPTIONAL_FIELDS));
        Iterator it = RulesWsParameters.OPTIONAL_FIELDS.iterator();
        paramFields.setExampleValue((Object)String.format("%s,%s", it.next(), it.next()));
        this.doDefinition(action);
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            SearchWsRequest searchWsRequest = SearchAction.toSearchWsRequest(request);
            SearchOptions context = SearchAction.buildSearchOptions(searchWsRequest);
            RuleQuery query = this.ruleQueryFactory.createRuleQuery(dbSession, request);
            SearchResult searchResult = this.doSearch(dbSession, query, context);
            Rules.SearchResponse responseBuilder = this.buildResponse(dbSession, searchWsRequest, context, searchResult, query);
            WsUtils.writeProtobuf((Message)responseBuilder, request, response);
        }
    }

    private Rules.SearchResponse buildResponse(DbSession dbSession, SearchWsRequest request, SearchOptions context, SearchResult result, RuleQuery query) {
        Rules.SearchResponse.Builder responseBuilder = Rules.SearchResponse.newBuilder();
        SearchAction.writeStatistics(responseBuilder, result, context);
        this.doContextResponse(dbSession, request, result, responseBuilder, query);
        if (!context.getFacets().isEmpty()) {
            SearchAction.writeFacets(responseBuilder, request, context, result);
        }
        return responseBuilder.build();
    }

    private static void writeStatistics(Rules.SearchResponse.Builder response, SearchResult searchResult, SearchOptions context) {
        response.setTotal(searchResult.total.longValue());
        response.setP(context.getPage());
        response.setPs((long)context.getLimit());
    }

    private void doDefinition(WebService.NewAction action) {
        action.setDescription("Search for a collection of relevant rules matching a specified query.<br/>Since 5.5, following fields in the response have been deprecated :<ul><li>\"effortToFixDescription\" becomes \"gapDescription\"</li><li>\"debtRemFnCoeff\" becomes \"remFnGapMultiplier\"</li><li>\"defaultDebtRemFnCoeff\" becomes \"defaultRemFnGapMultiplier\"</li><li>\"debtRemFnOffset\" becomes \"remFnBaseEffort\"</li><li>\"defaultDebtRemFnOffset\" becomes \"defaultRemFnBaseEffort\"</li><li>\"debtOverloaded\" becomes \"remFnOverloaded\"</li></ul>").setResponseExample(this.getClass().getResource("search-example.json")).setSince("4.4").setHandler((RequestHandler)this);
        SearchAction.defineRuleSearchParameters(action);
    }

    public static void defineRuleSearchParameters(WebService.NewAction action) {
        action.createParam("q").setDescription("UTF-8 search query").setExampleValue((Object)"xpath");
        action.createParam("rule_key").setDescription("Key of rule to search for").setExampleValue((Object)"squid:S001");
        action.createParam("repositories").setDescription("Comma-separated list of repositories").setExampleValue((Object)"checkstyle,findbugs");
        action.createParam("severities").setDescription("Comma-separated list of default severities. Not the same than severity of rules in Quality profiles.").setPossibleValues((Collection)Severity.ALL).setExampleValue((Object)"CRITICAL,BLOCKER");
        action.createParam("languages").setDescription("Comma-separated list of languages").setExampleValue((Object)"java,js");
        action.createParam("statuses").setDescription("Comma-separated list of status codes").setPossibleValues((Object[])RuleStatus.values()).setExampleValue((Object)RuleStatus.READY);
        action.createParam("available_since").setDescription("Filters rules added since date. Format is yyyy-MM-dd").setExampleValue((Object)"2014-06-22");
        action.createParam("tags").setDescription("Comma-separated list of tags. Returned rules match any of the tags (OR operator)").setExampleValue((Object)"security,java8");
        action.createParam("types").setSince("5.5").setDescription("Comma-separated list of types. Returned rules match any of the tags (OR operator)").setPossibleValues((Object[])RuleType.values()).setExampleValue((Object)RuleType.BUG);
        action.createParam("activation").setDescription("Filter rules that are activated or deactivated on the selected Quality profile. Ignored if the parameter 'qprofile' is not set.").setBooleanPossibleValues();
        action.createParam("qprofile").setDescription("Quality profile key to filter on. Used only if the parameter 'activation' is set.").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("compareToProfile").setDescription("Quality profile key to filter rules that are activated. Meant to compare easily to profile set in '%s'", new Object[]{"qprofile"}).setInternal(true).setSince("6.5").setExampleValue((Object)"AU-TpxcA-iU5OvuD2FLz");
        action.createParam("inheritance").setDescription("Comma-separated list of values of inheritance for a rule within a quality profile. Used only if the parameter 'activation' is set.").setPossibleValues(new Object[]{ActiveRule.Inheritance.NONE.name(), ActiveRule.Inheritance.INHERITED.name(), ActiveRule.Inheritance.OVERRIDES.name()}).setExampleValue((Object)(ActiveRule.Inheritance.INHERITED.name() + "," + ActiveRule.Inheritance.OVERRIDES.name()));
        action.createParam("active_severities").setDescription("Comma-separated list of activation severities, i.e the severity of rules in Quality profiles.").setPossibleValues((Collection)Severity.ALL).setExampleValue((Object)"CRITICAL,BLOCKER");
        action.createParam("is_template").setDescription("Filter template rules").setBooleanPossibleValues();
        action.createParam("template_key").setDescription("Key of the template rule to filter on. Used to search for the custom rules based on this template.").setExampleValue((Object)"java:S001");
        action.createParam("s").setDescription("Sort field").setPossibleValues(RuleIndexDefinition.SORT_FIELDS).setExampleValue((Object)RuleIndexDefinition.SORT_FIELDS.iterator().next());
        action.createParam("asc").setDescription("Ascending sort").setBooleanPossibleValues().setDefaultValue((Object)true);
        action.createParam("organization").setDescription("Organization key").setRequired(false).setInternal(true).setExampleValue((Object)"my-org").setSince("6.4");
    }

    private void writeRules(Rules.SearchResponse.Builder response, SearchResult result, SearchOptions context) {
        for (RuleDto rule : result.rules) {
            response.addRules(this.mapper.toWsRule(rule.getDefinition(), result, context.getFields(), rule.getMetadata()));
        }
    }

    private static SearchOptions buildSearchOptions(SearchWsRequest request) {
        SearchOptions context = SearchAction.loadCommonContext(request);
        SearchOptions searchOptions = new SearchOptions().setLimit(context.getLimit()).setOffset(context.getOffset());
        if (context.getFacets().contains("true")) {
            searchOptions.addFacets(DEFAULT_FACETS);
        } else {
            searchOptions.addFacets(context.getFacets());
        }
        return searchOptions;
    }

    private static SearchOptions loadCommonContext(SearchWsRequest request) {
        int pageSize = request.getPageSize();
        SearchOptions context = new SearchOptions().addFields(request.getFields());
        if (request.getFacets() != null) {
            context.addFacets(request.getFacets());
        }
        if (pageSize < 1) {
            context.setPage(request.getPage(), 0).setLimit(500);
        } else {
            context.setPage(request.getPage(), pageSize);
        }
        return context;
    }

    private SearchResult doSearch(DbSession dbSession, RuleQuery query, SearchOptions context) {
        SearchIdResult<RuleKey> result = this.ruleIndex.search(query, context);
        List<RuleKey> ruleKeys = result.getIds();
        ImmutableMap rulesByRuleKey = Maps.uniqueIndex((Iterable)this.dbClient.ruleDao().selectByKeys(dbSession, query.getOrganization(), ruleKeys), RuleDto::getKey);
        ArrayList<RuleDto> rules = new ArrayList<RuleDto>();
        for (RuleKey ruleKey : ruleKeys) {
            RuleDto rule = (RuleDto)rulesByRuleKey.get(ruleKey);
            if (rule == null) continue;
            rules.add(rule);
        }
        List ruleIds = (List)rules.stream().map(RuleDto::getId).collect(MoreCollectors.toList());
        List templateRuleIds = (List)rules.stream().map(RuleDto::getTemplateId).filter(Objects::nonNull).collect(MoreCollectors.toList());
        List templateRules = this.dbClient.ruleDao().selectDefinitionByIds(dbSession, templateRuleIds);
        List ruleParamDtos = this.dbClient.ruleDao().selectRuleParamsByRuleIds(dbSession, ruleIds);
        return new SearchResult().setRules(rules).setRuleParameters(ruleParamDtos).setTemplateRules(templateRules).setFacets(result.getFacets()).setTotal(result.getTotal());
    }

    private void doContextResponse(DbSession dbSession, SearchWsRequest request, SearchResult result, Rules.SearchResponse.Builder response, RuleQuery query) {
        SearchOptions contextForResponse = SearchAction.loadCommonContext(request);
        this.writeRules(response, result, contextForResponse);
        if (contextForResponse.getFields().contains("actives")) {
            this.activeRuleCompleter.completeSearch(dbSession, query, result.rules, response);
        }
    }

    private static void writeFacets(Rules.SearchResponse.Builder response, SearchWsRequest request, SearchOptions context, SearchResult results) {
        SearchAction.addMandatoryFacetValues(results, "languages", request.getLanguages());
        SearchAction.addMandatoryFacetValues(results, "repositories", request.getRepositories());
        SearchAction.addMandatoryFacetValues(results, "statuses", RuleIndex.ALL_STATUSES_EXCEPT_REMOVED);
        SearchAction.addMandatoryFacetValues(results, "severities", Severity.ALL);
        SearchAction.addMandatoryFacetValues(results, "active_severities", Severity.ALL);
        SearchAction.addMandatoryFacetValues(results, "tags", request.getTags());
        SearchAction.addMandatoryFacetValues(results, "types", RuleType.names());
        Common.Facet.Builder facet = Common.Facet.newBuilder();
        Common.FacetValue.Builder value = Common.FacetValue.newBuilder();
        HashMap<String, List> facetValuesByFacetKey = new HashMap<String, List>();
        facetValuesByFacetKey.put("languages", request.getLanguages());
        facetValuesByFacetKey.put("repositories", request.getRepositories());
        facetValuesByFacetKey.put("statuses", request.getStatuses());
        facetValuesByFacetKey.put("severities", request.getSeverities());
        facetValuesByFacetKey.put("active_severities", request.getActiveSeverities());
        facetValuesByFacetKey.put("tags", request.getTags());
        facetValuesByFacetKey.put("types", request.getTypes());
        for (String facetName : context.getFacets()) {
            facet.clear().setProperty(facetName);
            LinkedHashMap<String, Long> facets = results.facets.get(facetName);
            if (facets != null) {
                HashSet<String> itemsFromFacets = new HashSet<String>();
                for (Map.Entry facetValue : facets.entrySet()) {
                    itemsFromFacets.add((String)facetValue.getKey());
                    facet.addValues(value.clear().setVal((String)facetValue.getKey()).setCount(((Long)facetValue.getValue()).longValue()));
                }
                SearchAction.addZeroFacetsForSelectedItems(facet, (List)facetValuesByFacetKey.get(facetName), itemsFromFacets);
            }
            response.getFacetsBuilder().addFacets(facet);
        }
    }

    private static void addZeroFacetsForSelectedItems(Common.Facet.Builder facet, @Nullable List<String> requestParams, Set<String> itemsFromFacets) {
        if (requestParams != null) {
            Common.FacetValue.Builder value = Common.FacetValue.newBuilder();
            for (String param : requestParams) {
                if (itemsFromFacets.contains(param)) continue;
                facet.addValues(value.clear().setVal(param).setCount(0L));
            }
        }
    }

    private static void addMandatoryFacetValues(SearchResult results, String facetName, @Nullable Collection<String> mandatoryValues) {
        LinkedHashMap<String, Long> facetValues = results.facets.get(facetName);
        if (facetValues != null) {
            Collection<Object> valuesToAdd = mandatoryValues == null ? Lists.newArrayList() : mandatoryValues;
            for (String string : valuesToAdd) {
                if (facetValues.containsKey(string)) continue;
                facetValues.put(string, 0L);
            }
        }
    }

    private static SearchWsRequest toSearchWsRequest(Request request) {
        return new SearchWsRequest().setActivation(request.paramAsBoolean("activation")).setActiveSeverities(request.paramAsStrings("active_severities")).setAsc(Boolean.valueOf(request.mandatoryParamAsBoolean("asc"))).setAvailableSince(request.param("available_since")).setFields(request.paramAsStrings("f")).setFacets(request.paramAsStrings("facets")).setInheritance(request.paramAsStrings("inheritance")).setIsTemplate(request.paramAsBoolean("is_template")).setLanguages(request.paramAsStrings("languages")).setPage(Integer.valueOf(request.mandatoryParamAsInt("p"))).setPageSize(Integer.valueOf(request.mandatoryParamAsInt("ps"))).setQuery(request.param("q")).setQProfile(request.param("qprofile")).setRepositories(request.paramAsStrings("repositories")).setRuleKey(request.param("rule_key")).setSort(request.param("s")).setSeverities(request.paramAsStrings("severities")).setStatuses(request.paramAsStrings("statuses")).setTags(request.paramAsStrings("tags")).setTemplateKey(request.param("template_key")).setTypes(request.paramAsStrings("types"));
    }

    static class SearchResult {
        private List<RuleDto> rules = new ArrayList<RuleDto>();
        private final ListMultimap<Integer, RuleParamDto> ruleParamsByRuleId = ArrayListMultimap.create();
        private final Map<Integer, RuleDefinitionDto> templateRulesByRuleId = new HashMap<Integer, RuleDefinitionDto>();
        private Long total;
        private Facets facets;

        public List<RuleDto> getRules() {
            return this.rules;
        }

        public SearchResult setRules(List<RuleDto> rules) {
            this.rules = rules;
            return this;
        }

        public ListMultimap<Integer, RuleParamDto> getRuleParamsByRuleId() {
            return this.ruleParamsByRuleId;
        }

        public SearchResult setRuleParameters(List<RuleParamDto> ruleParams) {
            this.ruleParamsByRuleId.clear();
            for (RuleParamDto ruleParam : ruleParams) {
                this.ruleParamsByRuleId.put((Object)ruleParam.getRuleId(), (Object)ruleParam);
            }
            return this;
        }

        public Map<Integer, RuleDefinitionDto> getTemplateRulesByRuleId() {
            return this.templateRulesByRuleId;
        }

        public SearchResult setTemplateRules(List<RuleDefinitionDto> templateRules) {
            this.templateRulesByRuleId.clear();
            for (RuleDefinitionDto templateRule : templateRules) {
                this.templateRulesByRuleId.put(templateRule.getId(), templateRule);
            }
            return this;
        }

        @CheckForNull
        public Long getTotal() {
            return this.total;
        }

        public SearchResult setTotal(Long total) {
            this.total = total;
            return this;
        }

        @CheckForNull
        public Facets getFacets() {
            return this.facets;
        }

        public SearchResult setFacets(Facets facets) {
            this.facets = facets;
            return this;
        }
    }
}

