/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.root.ws;

import com.google.protobuf.Message;
import java.util.List;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.user.UserQuery;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.server.root.ws.RootsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsRoot;

public class SearchAction
implements RootsWsAction {
    private final UserSession userSession;
    private final DbClient dbClient;

    public SearchAction(UserSession userSession, DbClient dbClient) {
        this.userSession = userSession;
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController controller) {
        controller.createAction("search").setInternal(true).setPost(false).setDescription("Search for root users.<br/>Requires to be root.").setSince("6.2").setResponseExample(this.getClass().getResource("search-example.json")).setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkIsRoot();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List userDtos = this.dbClient.userDao().selectUsers(dbSession, UserQuery.builder().mustBeRoot().build());
            SearchAction.writeResponse(request, response, userDtos);
        }
    }

    private static void writeResponse(Request request, Response response, List<UserDto> dtos) {
        WsRoot.SearchWsResponse.Builder responseBuilder = WsRoot.SearchWsResponse.newBuilder();
        WsRoot.Root.Builder rootBuilder = WsRoot.Root.newBuilder();
        dtos.forEach(dto -> responseBuilder.addRoots(SearchAction.toRoot(rootBuilder, dto)));
        WsUtils.writeProtobuf((Message)responseBuilder.build(), request, response);
    }

    private static WsRoot.Root toRoot(WsRoot.Root.Builder builder, UserDto dto) {
        builder.clear();
        builder.setLogin(dto.getLogin());
        if (dto.getName() != null) {
            builder.setName(dto.getName());
        }
        if (dto.getEmail() != null) {
            builder.setEmail(dto.getEmail());
        }
        return builder.build();
    }
}

