/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import org.sonar.api.profiles.ProfileImporter;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;

public class ImportersAction
implements QProfileWsAction {
    private final ProfileImporter[] importers;

    public ImportersAction(ProfileImporter[] importers) {
        this.importers = importers;
    }

    public ImportersAction() {
        this(new ProfileImporter[0]);
    }

    public void define(WebService.NewController controller) {
        controller.createAction("importers").setSince("5.2").setDescription("List supported importers.").setResponseExample(this.getClass().getResource("importers-example.json")).setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) throws Exception {
        try (JsonWriter json = response.newJsonWriter();){
            json.beginObject().name("importers").beginArray();
            for (ProfileImporter importer : this.importers) {
                json.beginObject().prop("key", importer.getKey()).prop("name", importer.getName()).name("languages").beginArray();
                for (String languageKey : importer.getSupportedLanguages()) {
                    json.value(languageKey);
                }
                json.endArray().endObject();
            }
            json.endArray().endObject();
        }
    }
}

