/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.resources.Languages;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.qualityprofile.RuleActivator;
import org.sonar.server.qualityprofile.ws.QProfileReference;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;
import org.sonar.server.user.UserSession;

public class ChangeParentAction
implements QProfileWsAction {
    private final DbClient dbClient;
    private final RuleActivator ruleActivator;
    private final Languages languages;
    private final QProfileWsSupport wsSupport;
    private final UserSession userSession;

    public ChangeParentAction(DbClient dbClient, RuleActivator ruleActivator, Languages languages, QProfileWsSupport wsSupport, UserSession userSession) {
        this.dbClient = dbClient;
        this.ruleActivator = ruleActivator;
        this.languages = languages;
        this.wsSupport = wsSupport;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction inheritance = context.createAction("change_parent").setSince("5.2").setPost(true).setDescription("Change a quality profile's parent.<br>Requires one of the following permissions:<ul>  <li>'Administer Quality Profiles'</li>  <li>Edit right on the specified quality profile</li></ul>").setHandler((RequestHandler)this);
        QProfileWsSupport.createOrganizationParam(inheritance).setSince("6.4");
        QProfileReference.defineParams(inheritance, this.languages);
        inheritance.createParam("parentKey").setDescription("New parent profile key.<br> If no profile is provided, the inheritance link with current parent profile (if any) is broken, which deactivates all rules which come from the parent and are not overridden.").setDeprecatedSince("6.6").setExampleValue((Object)"AU-TpxcA-iU5OvuD2FLz");
        inheritance.createParam("parentQualityProfile").setDescription("Quality profile name. If this parameter is set, '%s' must not be set and '%s' must be set to disambiguate.", new Object[]{"parentKey", "language"}).setExampleValue((Object)"Sonar way");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        QProfileReference reference = QProfileReference.from(request);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            QProfileDto profile = this.wsSupport.getProfile(dbSession, reference);
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, profile);
            this.wsSupport.checkCanEdit(dbSession, organization, profile);
            String parentKey = request.param("parentKey");
            String parentName = request.param("parentQualityProfile");
            if (StringUtils.isEmpty((String)parentKey) && StringUtils.isEmpty((String)parentName)) {
                this.ruleActivator.setParentAndCommit(dbSession, profile, null);
            } else {
                String parentOrganizationKey = parentKey == null ? organization.getKey() : null;
                String parentLanguage = parentKey == null ? request.param("language") : null;
                QProfileReference parentRef = QProfileReference.from(parentKey, parentOrganizationKey, parentLanguage, parentName);
                QProfileDto parent = this.wsSupport.getProfile(dbSession, parentRef);
                this.ruleActivator.setParentAndCommit(dbSession, profile, parent);
            }
            response.noContent();
        }
    }
}

