/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.utils.System2;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.ActiveRuleDao;
import org.sonar.db.qualityprofile.ActiveRuleDto;
import org.sonar.db.qualityprofile.ActiveRuleKey;
import org.sonar.db.qualityprofile.ActiveRuleParamDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.qualityprofile.RulesProfileDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleParamDto;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.qualityprofile.ActiveRule;
import org.sonar.server.qualityprofile.ActiveRuleChange;
import org.sonar.server.qualityprofile.BulkChangeResult;
import org.sonar.server.qualityprofile.RuleActivation;
import org.sonar.server.qualityprofile.RuleActivatorContext;
import org.sonar.server.qualityprofile.RuleActivatorContextFactory;
import org.sonar.server.qualityprofile.index.ActiveRuleIndexer;
import org.sonar.server.rule.index.RuleIndex;
import org.sonar.server.rule.index.RuleQuery;
import org.sonar.server.user.UserSession;
import org.sonar.server.util.TypeValidations;
import org.sonar.server.ws.WsUtils;

@ServerSide
public class RuleActivator {
    private final System2 system2;
    private final DbClient db;
    private final TypeValidations typeValidations;
    private final RuleActivatorContextFactory contextFactory;
    private final RuleIndex ruleIndex;
    private final ActiveRuleIndexer activeRuleIndexer;
    private final UserSession userSession;

    public RuleActivator(System2 system2, DbClient db, RuleIndex ruleIndex, RuleActivatorContextFactory contextFactory, TypeValidations typeValidations, ActiveRuleIndexer activeRuleIndexer, UserSession userSession) {
        this.system2 = system2;
        this.db = db;
        this.ruleIndex = ruleIndex;
        this.contextFactory = contextFactory;
        this.typeValidations = typeValidations;
        this.activeRuleIndexer = activeRuleIndexer;
        this.userSession = userSession;
    }

    public List<ActiveRuleChange> activateOnBuiltInRulesProfile(DbSession dbSession, RuleActivation activation, RulesProfileDto rulesProfile) {
        Preconditions.checkArgument((boolean)rulesProfile.isBuiltIn(), (Object)("Rules profile must be a built-in profile: " + rulesProfile.getKee()));
        RuleActivatorContext context = this.contextFactory.createForBuiltIn(dbSession, activation.getRuleKey(), rulesProfile);
        return this.doActivate(dbSession, activation, context);
    }

    public List<ActiveRuleChange> activateAndCommit(DbSession dbSession, RuleActivation activation, QProfileDto profile) {
        List<ActiveRuleChange> changes = this.activate(dbSession, activation, profile);
        this.activeRuleIndexer.commitAndIndex(dbSession, changes);
        return changes;
    }

    public List<ActiveRuleChange> activate(DbSession dbSession, RuleActivation activation, QProfileDto profile) {
        RuleActivatorContext context = this.contextFactory.create(dbSession, activation.getRuleKey(), profile, false);
        return this.doActivate(dbSession, activation, context);
    }

    private List<ActiveRuleChange> doActivate(DbSession dbSession, RuleActivation activation, RuleActivatorContext context) {
        ActiveRuleChange change;
        context.verifyForActivation();
        ArrayList<ActiveRuleChange> changes = new ArrayList<ActiveRuleChange>();
        boolean stopPropagation = false;
        ActiveRuleDto activeRule = context.activeRule();
        if (activeRule == null) {
            if (activation.isReset()) {
                return changes;
            }
            change = new ActiveRuleChange(ActiveRuleChange.Type.ACTIVATED, context.activeRuleKey());
            this.applySeverityAndParamToChange(activation, context, change);
            if (context.isCascade() || context.isSameAsParent(change)) {
                change.setInheritance(ActiveRule.Inheritance.INHERITED);
            }
        } else {
            if (context.isCascade() && activeRule.doesOverride()) {
                return changes;
            }
            change = new ActiveRuleChange(ActiveRuleChange.Type.UPDATED, context.activeRuleKey());
            if (context.isCascade() && activeRule.getInheritance() == null) {
                change.setInheritance(ActiveRule.Inheritance.OVERRIDES);
                change.setSeverity(context.currentSeverity());
                change.setParameters(context.activeRuleParamsAsStringMap());
                stopPropagation = true;
            } else {
                this.applySeverityAndParamToChange(activation, context, change);
                if (!context.isCascade() && context.parentActiveRule() != null) {
                    change.setInheritance(context.isSameAsParent(change) ? ActiveRule.Inheritance.INHERITED : ActiveRule.Inheritance.OVERRIDES);
                }
            }
            if (context.isSame(change)) {
                change = null;
            }
        }
        if (change != null) {
            changes.add(change);
            this.persist(change, context, dbSession);
        }
        if (!stopPropagation) {
            changes.addAll(this.cascadeActivation(dbSession, activation, context));
        }
        if (!changes.isEmpty()) {
            this.updateProfileDates(dbSession, context);
        }
        return changes;
    }

    private void updateProfileDates(DbSession dbSession, RuleActivatorContext context) {
        QProfileDto profile = context.getProfile();
        if (profile != null) {
            profile.setRulesUpdatedAtAsDate(context.getInitDate());
            if (this.userSession.isLoggedIn()) {
                profile.setUserUpdatedAt(Long.valueOf(context.getInitDate().getTime()));
            }
            this.db.qualityProfileDao().update(dbSession, profile, new QProfileDto[0]);
        } else {
            RulesProfileDto rulesProfile = context.getRulesProfile();
            rulesProfile.setRulesUpdatedAtAsDate(context.getInitDate());
            this.db.qualityProfileDao().update(dbSession, rulesProfile);
        }
    }

    private void applySeverityAndParamToChange(RuleActivation request, RuleActivatorContext context, ActiveRuleChange change) {
        String severity = request.isReset() ? RuleActivator.firstNonNull(context.parentSeverity(), context.defaultSeverity()) : (context.getRulesProfile().isBuiltIn() ? RuleActivator.firstNonNull(request.getSeverity(), context.defaultSeverity()) : RuleActivator.firstNonNull(request.getSeverity(), context.currentSeverity(), context.parentSeverity(), context.defaultSeverity()));
        change.setSeverity(severity);
        for (RuleParamDto ruleParamDto : context.ruleParams()) {
            String paramKey = ruleParamDto.getName();
            String paramValue = request.isReset() ? RuleActivator.firstNonNull(context.parentParamValue(paramKey), context.defaultParamValue(paramKey)) : (context.getRulesProfile().isBuiltIn() ? RuleActivator.firstNonNull(context.requestParamValue(request, paramKey), context.defaultParamValue(paramKey)) : (context.hasRequestParamValue(request, paramKey) ? RuleActivator.firstNonNull(context.requestParamValue(request, paramKey), context.parentParamValue(paramKey), context.defaultParamValue(paramKey)) : RuleActivator.firstNonNull(context.currentParamValue(paramKey), context.parentParamValue(paramKey), context.defaultParamValue(paramKey))));
            change.setParameter(paramKey, this.validateParam(ruleParamDto, paramValue));
        }
    }

    @CheckForNull
    private static String firstNonNull(String ... strings) {
        for (String s : strings) {
            if (s == null) continue;
            return s;
        }
        return null;
    }

    private List<ActiveRuleChange> cascadeActivation(DbSession dbSession, RuleActivation activation, RuleActivatorContext context) {
        ArrayList<ActiveRuleChange> changes = new ArrayList<ActiveRuleChange>();
        this.getChildren(dbSession, context).forEach(child -> {
            RuleActivatorContext childContext = this.contextFactory.create(dbSession, activation.getRuleKey(), (QProfileDto)child, true);
            changes.addAll(this.doActivate(dbSession, activation, childContext));
        });
        return changes;
    }

    protected List<QProfileDto> getChildren(DbSession session, RuleActivatorContext context) {
        if (context.getProfile() != null) {
            return this.db.qualityProfileDao().selectChildren(session, context.getProfile());
        }
        return this.db.qualityProfileDao().selectChildrenOfBuiltInRulesProfile(session, context.getRulesProfile());
    }

    private void persist(ActiveRuleChange change, RuleActivatorContext context, DbSession dbSession) {
        ActiveRuleDto activeRule = null;
        if (change.getType() == ActiveRuleChange.Type.ACTIVATED) {
            activeRule = this.doInsert(change, context, dbSession);
        } else if (change.getType() == ActiveRuleChange.Type.DEACTIVATED) {
            ActiveRuleDao dao = this.db.activeRuleDao();
            activeRule = dao.delete(dbSession, change.getKey()).orElse(null);
        } else if (change.getType() == ActiveRuleChange.Type.UPDATED) {
            activeRule = this.doUpdate(change, context, dbSession);
        }
        change.setActiveRule(activeRule);
        this.db.qProfileChangeDao().insert(dbSession, change.toDto(this.userSession.getLogin()));
    }

    private ActiveRuleDto doInsert(ActiveRuleChange change, RuleActivatorContext context, DbSession dbSession) {
        ActiveRule.Inheritance inheritance;
        ActiveRuleDao dao = this.db.activeRuleDao();
        ActiveRuleDto activeRule = new ActiveRuleDto();
        activeRule.setProfileId(context.getRulesProfile().getId());
        activeRule.setRuleId(context.getRule().getId());
        activeRule.setKey(ActiveRuleKey.of((RulesProfileDto)context.getRulesProfile(), (RuleKey)context.getRule().getKey()));
        String severity = change.getSeverity();
        if (severity != null) {
            activeRule.setSeverity(severity);
        }
        if ((inheritance = change.getInheritance()) != null) {
            activeRule.setInheritance(inheritance.name());
        }
        activeRule.setUpdatedAt(this.system2.now());
        activeRule.setCreatedAt(this.system2.now());
        dao.insert(dbSession, activeRule);
        for (Map.Entry<String, String> param : change.getParameters().entrySet()) {
            if (param.getValue() == null) continue;
            ActiveRuleParamDto paramDto = ActiveRuleParamDto.createFor((RuleParamDto)context.ruleParamsByKeys().get(param.getKey()));
            paramDto.setValue(param.getValue());
            dao.insertParam(dbSession, activeRule, paramDto);
        }
        return activeRule;
    }

    private ActiveRuleDto doUpdate(ActiveRuleChange change, RuleActivatorContext context, DbSession dbSession) {
        ActiveRuleDao dao = this.db.activeRuleDao();
        ActiveRuleDto activeRule = context.activeRule();
        if (activeRule != null) {
            ActiveRule.Inheritance inheritance;
            String severity = change.getSeverity();
            if (severity != null) {
                activeRule.setSeverity(severity);
            }
            if ((inheritance = change.getInheritance()) != null) {
                activeRule.setInheritance(inheritance.name());
            }
            activeRule.setUpdatedAt(this.system2.now());
            dao.update(dbSession, activeRule);
            for (Map.Entry<String, String> param : change.getParameters().entrySet()) {
                ActiveRuleParamDto activeRuleParamDto = context.activeRuleParamsAsMap().get(param.getKey());
                if (activeRuleParamDto == null) {
                    if (param.getValue() == null) continue;
                    activeRuleParamDto = ActiveRuleParamDto.createFor((RuleParamDto)context.ruleParamsByKeys().get(param.getKey()));
                    activeRuleParamDto.setValue(param.getValue());
                    dao.insertParam(dbSession, activeRule, activeRuleParamDto);
                    continue;
                }
                if (param.getValue() != null) {
                    activeRuleParamDto.setValue(param.getValue());
                    dao.updateParam(dbSession, activeRuleParamDto);
                    continue;
                }
                dao.deleteParam(dbSession, activeRuleParamDto);
            }
        }
        return activeRule;
    }

    public void deactivateAndCommit(DbSession dbSession, QProfileDto profile, RuleKey ruleKey) {
        List<ActiveRuleChange> changes = this.deactivate(dbSession, profile, ruleKey);
        this.activeRuleIndexer.commitAndIndex(dbSession, changes);
    }

    List<ActiveRuleChange> deactivate(DbSession dbSession, QProfileDto profile, RuleKey ruleKey) {
        return this.deactivate(dbSession, profile, ruleKey, false);
    }

    public List<ActiveRuleChange> delete(DbSession dbSession, RuleDefinitionDto rule) {
        ArrayList<ActiveRuleChange> changes = new ArrayList<ActiveRuleChange>();
        ArrayList activeRuleIds = new ArrayList();
        this.db.activeRuleDao().selectByRuleIdOfAllOrganizations(dbSession, rule.getId().intValue()).forEach(ar -> {
            activeRuleIds.add(ar.getId());
            changes.add(new ActiveRuleChange(ActiveRuleChange.Type.DEACTIVATED, (ActiveRuleDto)ar));
        });
        this.db.activeRuleDao().deleteByIds(dbSession, activeRuleIds);
        this.db.activeRuleDao().deleteParamsByActiveRuleIds(dbSession, activeRuleIds);
        return changes;
    }

    public List<ActiveRuleChange> deactivate(DbSession dbSession, QProfileDto profile, RuleKey ruleKey, boolean force) {
        RuleActivatorContext context = this.contextFactory.create(dbSession, ruleKey, profile, false);
        return this.cascadeDeactivation(dbSession, context, ruleKey, force);
    }

    public List<ActiveRuleChange> deactivateOnBuiltInRulesProfile(DbSession dbSession, RulesProfileDto rulesProfile, RuleKey ruleKey, boolean force) {
        Preconditions.checkArgument((boolean)rulesProfile.isBuiltIn(), (Object)("Rules profile must be a built-in profile: " + rulesProfile.getKee()));
        RuleActivatorContext context = this.contextFactory.createForBuiltIn(dbSession, ruleKey, rulesProfile);
        return this.cascadeDeactivation(dbSession, context, ruleKey, force);
    }

    private List<ActiveRuleChange> cascadeDeactivation(DbSession dbSession, RuleActivatorContext context, RuleKey ruleKey, boolean force) {
        ArrayList<ActiveRuleChange> changes = new ArrayList<ActiveRuleChange>();
        ActiveRuleDto activeRuleDto = context.activeRule();
        if (activeRuleDto == null) {
            return changes;
        }
        WsUtils.checkRequest(force || context.isCascade() || activeRuleDto.getInheritance() == null, "Cannot deactivate inherited rule '%s'", ruleKey);
        ActiveRuleChange change = new ActiveRuleChange(ActiveRuleChange.Type.DEACTIVATED, activeRuleDto);
        changes.add(change);
        this.persist(change, context, dbSession);
        this.getChildren(dbSession, context).forEach(child -> {
            RuleActivatorContext childContext = this.contextFactory.create(dbSession, ruleKey, (QProfileDto)child, true);
            changes.addAll(this.cascadeDeactivation(dbSession, childContext, ruleKey, force));
        });
        if (!changes.isEmpty()) {
            this.updateProfileDates(dbSession, context);
        }
        return changes;
    }

    @CheckForNull
    private String validateParam(RuleParamDto ruleParam, @Nullable String value) {
        if (value != null) {
            RuleParamType ruleParamType = RuleParamType.parse((String)ruleParam.getType());
            if (ruleParamType.multiple()) {
                List values = Splitter.on((String)",").splitToList((CharSequence)value);
                this.typeValidations.validate(values, ruleParamType.type(), (List<String>)ruleParamType.values());
            } else {
                this.typeValidations.validate(value, ruleParamType.type(), (List<String>)ruleParamType.values());
            }
        }
        return value;
    }

    public BulkChangeResult bulkActivateAndCommit(DbSession dbSession, RuleQuery ruleQuery, QProfileDto profile, @Nullable String severity) {
        BulkChangeResult result = new BulkChangeResult();
        Iterator<RuleKey> rules = this.ruleIndex.searchAll(ruleQuery);
        while (rules.hasNext()) {
            RuleKey ruleKey = rules.next();
            try {
                RuleActivation activation = RuleActivation.create(ruleKey, severity, null);
                List<ActiveRuleChange> changes = this.activate(dbSession, activation, profile);
                result.addChanges(changes);
                if (changes.isEmpty()) continue;
                result.incrementSucceeded();
            }
            catch (BadRequestException e) {
                result.incrementFailed();
                result.getErrors().addAll(e.errors());
            }
        }
        this.activeRuleIndexer.commitAndIndex(dbSession, result.getChanges());
        return result;
    }

    public BulkChangeResult bulkDeactivateAndCommit(DbSession dbSession, RuleQuery ruleQuery, QProfileDto profile) {
        BulkChangeResult result = new BulkChangeResult();
        Iterator<RuleKey> rules = this.ruleIndex.searchAll(ruleQuery);
        while (rules.hasNext()) {
            try {
                RuleKey ruleKey = rules.next();
                List<ActiveRuleChange> changes = this.deactivate(dbSession, profile, ruleKey);
                result.addChanges(changes);
                if (changes.isEmpty()) continue;
                result.incrementSucceeded();
            }
            catch (BadRequestException e) {
                result.incrementFailed();
                result.getErrors().addAll(e.errors());
            }
        }
        this.activeRuleIndexer.commitAndIndex(dbSession, result.getChanges());
        return result;
    }

    public List<ActiveRuleChange> setParentAndCommit(DbSession dbSession, QProfileDto profile, @Nullable QProfileDto parent) {
        WsUtils.checkRequest(parent == null || profile.getLanguage().equals(parent.getLanguage()), "Cannot set the profile '%s' as the parent of profile '%s' since their languages differ ('%s' != '%s')", parent != null ? parent.getKee() : "", profile.getKee(), parent != null ? parent.getLanguage() : "", profile.getLanguage());
        ArrayList<ActiveRuleChange> changes = new ArrayList<ActiveRuleChange>();
        if (parent == null) {
            changes.addAll(this.removeParent(dbSession, profile));
        } else if (profile.getParentKee() == null || !parent.getKee().equals(profile.getParentKee())) {
            WsUtils.checkRequest(!this.isDescendant(dbSession, profile, parent), "Descendant profile '%s' can not be selected as parent of '%s'", parent.getKee(), profile.getKee());
            changes.addAll(this.removeParent(dbSession, profile));
            profile.setParentKee(parent.getKee());
            this.db.qualityProfileDao().update(dbSession, profile, new QProfileDto[0]);
            for (ActiveRuleDto parentActiveRule : this.db.activeRuleDao().selectByProfile(dbSession, parent)) {
                try {
                    RuleActivation activation = RuleActivation.create(parentActiveRule.getRuleKey(), null, null);
                    changes.addAll(this.activate(dbSession, activation, profile));
                }
                catch (BadRequestException badRequestException) {}
            }
        }
        this.activeRuleIndexer.commitAndIndex(dbSession, changes);
        return changes;
    }

    private List<ActiveRuleChange> removeParent(DbSession dbSession, QProfileDto profile) {
        if (profile.getParentKee() != null) {
            ArrayList<ActiveRuleChange> changes = new ArrayList<ActiveRuleChange>();
            profile.setParentKee(null);
            this.db.qualityProfileDao().update(dbSession, profile, new QProfileDto[0]);
            for (ActiveRuleDto activeRule : this.db.activeRuleDao().selectByProfile(dbSession, profile)) {
                if ("INHERITED".equals(activeRule.getInheritance())) {
                    changes.addAll(this.deactivate(dbSession, profile, activeRule.getRuleKey(), true));
                    continue;
                }
                if (!"OVERRIDES".equals(activeRule.getInheritance())) continue;
                activeRule.setInheritance(null);
                activeRule.setUpdatedAt(this.system2.now());
                this.db.activeRuleDao().update(dbSession, activeRule);
                changes.add(new ActiveRuleChange(ActiveRuleChange.Type.UPDATED, activeRule).setInheritance(null));
            }
            return changes;
        }
        return Collections.emptyList();
    }

    private boolean isDescendant(DbSession dbSession, QProfileDto childProfile, @Nullable QProfileDto parentProfile) {
        QProfileDto currentParent = parentProfile;
        while (currentParent != null) {
            if (childProfile.getName().equals(currentParent.getName())) {
                return true;
            }
            String parentKey = currentParent.getParentKee();
            if (parentKey != null) {
                currentParent = this.db.qualityProfileDao().selectByUuid(dbSession, parentKey);
                continue;
            }
            currentParent = null;
        }
        return false;
    }
}

