/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.TempFolder;
import org.sonar.core.util.FileUtils;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.qualityprofile.QProfileBackuper;
import org.sonar.server.qualityprofile.QProfileFactory;
import org.sonar.server.qualityprofile.QProfileName;

@ServerSide
public class QProfileCopier {
    private final DbClient db;
    private final QProfileFactory factory;
    private final QProfileBackuper backuper;
    private final TempFolder temp;

    public QProfileCopier(DbClient db, QProfileFactory factory, QProfileBackuper backuper, TempFolder temp) {
        this.db = db;
        this.factory = factory;
        this.backuper = backuper;
        this.temp = temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QProfileDto copyToName(DbSession dbSession, QProfileDto sourceProfile, String toName) {
        OrganizationDto organization = (OrganizationDto)this.db.organizationDao().selectByUuid(dbSession, sourceProfile.getOrganizationUuid()).orElseThrow(() -> new IllegalStateException("Organization with UUID [" + sourceProfile.getOrganizationUuid() + "] does not exist"));
        QProfileDto to = this.prepareTarget(dbSession, organization, sourceProfile, toName);
        File backupFile = this.temp.newFile();
        try {
            this.backup(dbSession, sourceProfile, backupFile);
            this.restore(dbSession, backupFile, to);
            QProfileDto qProfileDto = to;
            return qProfileDto;
        }
        finally {
            FileUtils.deleteQuietly((File)backupFile);
        }
    }

    private QProfileDto prepareTarget(DbSession dbSession, OrganizationDto organization, QProfileDto sourceProfile, String toName) {
        QProfileName toProfileName = new QProfileName(sourceProfile.getLanguage(), toName);
        this.verify(sourceProfile, toProfileName);
        QProfileDto toProfile = this.db.qualityProfileDao().selectByNameAndLanguage(dbSession, organization, toProfileName.getName(), toProfileName.getLanguage());
        if (toProfile == null) {
            toProfile = this.factory.checkAndCreateCustom(dbSession, organization, toProfileName);
            toProfile.setParentKee(sourceProfile.getParentKee());
            this.db.qualityProfileDao().update(dbSession, toProfile, new QProfileDto[0]);
            dbSession.commit();
        }
        return toProfile;
    }

    private void verify(QProfileDto fromProfile, QProfileName toProfileName) {
        if (fromProfile.getName().equals(toProfileName.getName())) {
            throw new IllegalArgumentException(String.format("Source and target profiles are equal: %s", fromProfile.getName()));
        }
    }

    private void backup(DbSession dbSession, QProfileDto profile, File backupFile) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)org.apache.commons.io.FileUtils.openOutputStream((File)backupFile), StandardCharsets.UTF_8);){
            this.backuper.backup(dbSession, profile, writer);
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to open temporary backup file: " + backupFile, e);
        }
    }

    private void restore(DbSession dbSession, File backupFile, QProfileDto profile) {
        try (InputStreamReader reader = new InputStreamReader((InputStream)org.apache.commons.io.FileUtils.openInputStream((File)backupFile), StandardCharsets.UTF_8);){
            this.backuper.restore(dbSession, reader, profile);
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to create temporary backup file: " + backupFile, e);
        }
    }
}

