/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import java.util.Collection;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.qualitygate.QualityGateConditionDto;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;

public class QualityGatesWs
implements WebService {
    private final QualityGatesWsAction[] actions;

    public QualityGatesWs(QualityGatesWsAction ... actions) {
        this.actions = actions;
    }

    public void define(WebService.Context context) {
        WebService.NewController controller = context.createController("api/qualitygates").setSince("4.3").setDescription("Manage quality gates, including conditions and project association.");
        for (QualityGatesWsAction action : this.actions) {
            action.define(controller);
        }
        controller.done();
    }

    static void addConditionParams(WebService.NewAction action) {
        action.createParam("metric").setDescription("Condition metric").setRequired(true).setExampleValue((Object)"blocker_violations");
        action.createParam("op").setDescription("Condition operator:<br/><ul><li>EQ = equals</li><li>NE = is not</li><li>LT = is lower than</li><li>GT = is greater than</li></ui>").setExampleValue((Object)"EQ").setPossibleValues((Collection)QualityGateConditionDto.ALL_OPERATORS);
        action.createParam("period").setDescription("Condition period. If not set, the absolute value is considered.").setPossibleValues(new Object[]{"1"});
        action.createParam("warning").setDescription("Condition warning threshold").setExampleValue((Object)"5");
        action.createParam("error").setDescription("Condition error threshold").setExampleValue((Object)"10");
    }

    static Long parseId(Request request, String paramName) {
        try {
            return Long.valueOf(request.mandatoryParam(paramName));
        }
        catch (NumberFormatException badFormat) {
            throw BadRequestException.create(paramName + " must be a valid long value");
        }
    }

    static JsonWriter writeQualityGate(QualityGateDto qualityGate, JsonWriter writer) {
        return writer.beginObject().prop("id", (Number)qualityGate.getId()).prop("name", qualityGate.getName()).endObject();
    }

    static JsonWriter writeQualityGateCondition(QualityGateConditionDto condition, JsonWriter writer) {
        writer.beginObject().prop("id", condition.getId()).prop("metric", condition.getMetricKey()).prop("op", condition.getOperator());
        if (condition.getWarningThreshold() != null) {
            writer.prop("warning", condition.getWarningThreshold());
        }
        if (condition.getErrorThreshold() != null) {
            writer.prop("error", condition.getErrorThreshold());
        }
        if (condition.getPeriod() != null) {
            writer.prop("period", (Number)condition.getPeriod());
        }
        writer.endObject();
        return writer;
    }
}

