/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.ws.WsUtils;

public class QualityGateUpdater {
    private final DbClient dbClient;

    public QualityGateUpdater(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public QualityGateDto create(DbSession dbSession, String name) {
        this.validateQualityGate(dbSession, null, name);
        QualityGateDto newQualityGate = new QualityGateDto().setName(name);
        this.dbClient.qualityGateDao().insert(dbSession, newQualityGate);
        return newQualityGate;
    }

    private void validateQualityGate(DbSession dbSession, @Nullable Long qGateId, @Nullable String name) {
        ArrayList<String> errors = new ArrayList<String>();
        if (Strings.isNullOrEmpty((String)name)) {
            errors.add(String.format("%s can't be empty", "Name"));
        } else {
            this.checkQualityGateDoesNotAlreadyExist(dbSession, qGateId, name, errors);
        }
        WsUtils.checkRequest(errors.isEmpty(), errors);
    }

    private void checkQualityGateDoesNotAlreadyExist(DbSession dbSession, @Nullable Long qGateId, String name, List<String> errors) {
        boolean isModifyingCurrentQgate;
        QualityGateDto existingQgate = this.dbClient.qualityGateDao().selectByName(dbSession, name);
        boolean bl = isModifyingCurrentQgate = qGateId != null && existingQgate != null && existingQgate.getId().equals(qGateId);
        if (!isModifyingCurrentQgate && existingQgate != null) {
            errors.add(String.format("%s has already been taken", "Name"));
        }
    }
}

