/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.projectlink.ws;

import com.google.protobuf.Message;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentLinkDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.projectlink.ws.ProjectLinksWsAction;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsProjectLinks;
import org.sonarqube.ws.client.projectlinks.SearchWsRequest;

public class SearchAction
implements ProjectLinksWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;

    public SearchAction(DbClient dbClient, UserSession userSession, ComponentFinder componentFinder) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search").setDescription("List links of a project.<br>The '%s' or '%s' must be provided.<br>Requires one of the following permissions:<ul><li>'Administer System'</li><li>'Administer' rights on the specified project</li><li>'Browse' on the specified project</li></ul>", new Object[]{"projectId", "projectKey"}).setHandler((RequestHandler)this).setResponseExample(this.getClass().getResource("list-example.json")).setSince("6.1");
        action.createParam("projectId").setDescription("Project Id").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("projectKey").setDescription("Project Key").setExampleValue((Object)"my_project");
    }

    public void handle(Request request, Response response) throws Exception {
        SearchWsRequest searchWsRequest = SearchAction.toSearchWsRequest(request);
        WsProjectLinks.SearchWsResponse searchWsResponse = this.doHandle(searchWsRequest);
        WsUtils.writeProtobuf((Message)searchWsResponse, request, response);
    }

    private WsProjectLinks.SearchWsResponse doHandle(SearchWsRequest searchWsRequest) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto component = this.getComponentByUuidOrKey(dbSession, searchWsRequest);
            List links = this.dbClient.componentLinkDao().selectByComponentUuid(dbSession, component.uuid());
            WsProjectLinks.SearchWsResponse searchWsResponse = SearchAction.buildResponse(links);
            return searchWsResponse;
        }
    }

    private static WsProjectLinks.SearchWsResponse buildResponse(List<ComponentLinkDto> links) {
        return WsProjectLinks.SearchWsResponse.newBuilder().addAllLinks((Iterable)links.stream().map(SearchAction::buildLink).collect(Collectors.toList())).build();
    }

    private static WsProjectLinks.Link buildLink(ComponentLinkDto link) {
        WsProjectLinks.Link.Builder builder = WsProjectLinks.Link.newBuilder().setId(String.valueOf(link.getId())).setUrl(link.getHref());
        Protobuf.setNullable((Object)link.getName(), arg_0 -> ((WsProjectLinks.Link.Builder)builder).setName(arg_0));
        Protobuf.setNullable((Object)link.getType(), arg_0 -> ((WsProjectLinks.Link.Builder)builder).setType(arg_0));
        return builder.build();
    }

    private ComponentDto getComponentByUuidOrKey(DbSession dbSession, SearchWsRequest request) {
        ComponentDto component = this.componentFinder.getRootComponentByUuidOrKey(dbSession, request.getProjectId(), request.getProjectKey(), ComponentFinder.ParamNames.PROJECT_ID_AND_KEY);
        if (!this.userSession.hasComponentPermission("admin", component) && !this.userSession.hasComponentPermission("user", component)) {
            throw AbstractUserSession.insufficientPrivilegesException();
        }
        return component;
    }

    private static SearchWsRequest toSearchWsRequest(Request request) {
        return new SearchWsRequest().setProjectId(request.param("projectId")).setProjectKey(request.param("projectKey"));
    }
}

