/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project.ws;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.api.utils.DateUtils;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentLinkDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.measure.MeasureDto;

class SearchMyProjectsData {
    private final List<ComponentDto> projects;
    private final ListMultimap<String, ComponentLinkDto> projectLinksByProjectUuid;
    private final Map<String, String> lastAnalysisDates;
    private final Map<String, String> qualityGateStatuses;
    private final int totalNbOfProject;

    private SearchMyProjectsData(Builder builder) {
        this.projects = ImmutableList.copyOf((Collection)builder.projects);
        this.projectLinksByProjectUuid = SearchMyProjectsData.buildProjectLinks(builder.projectLinks);
        this.lastAnalysisDates = SearchMyProjectsData.buildAnalysisDates(builder.snapshots);
        this.qualityGateStatuses = SearchMyProjectsData.buildQualityGateStatuses(builder.qualityGates);
        this.totalNbOfProject = builder.totalNbOfProjects;
    }

    static Builder builder() {
        return new Builder();
    }

    List<ComponentDto> projects() {
        return this.projects;
    }

    List<ComponentLinkDto> projectLinksFor(String projectUuid) {
        return this.projectLinksByProjectUuid.get((Object)projectUuid);
    }

    Optional<String> lastAnalysisDateFor(String componentUuid) {
        return Optional.ofNullable(this.lastAnalysisDates.get(componentUuid));
    }

    Optional<String> qualityGateStatusFor(String componentUuid) {
        return Optional.ofNullable(this.qualityGateStatuses.get(componentUuid));
    }

    int totalNbOfProjects() {
        return this.totalNbOfProject;
    }

    private static ListMultimap<String, ComponentLinkDto> buildProjectLinks(List<ComponentLinkDto> dtos) {
        ImmutableListMultimap.Builder projectLinks = ImmutableListMultimap.builder();
        dtos.forEach(projectLink -> projectLinks.put((Object)projectLink.getComponentUuid(), projectLink));
        return projectLinks.build();
    }

    private static Map<String, String> buildAnalysisDates(List<SnapshotDto> snapshots) {
        return ImmutableMap.copyOf(snapshots.stream().collect(Collectors.toMap(SnapshotDto::getComponentUuid, snapshot -> DateUtils.formatDateTime((long)snapshot.getCreatedAt()))));
    }

    private static Map<String, String> buildQualityGateStatuses(List<MeasureDto> measures) {
        return ImmutableMap.copyOf(measures.stream().collect(Collectors.toMap(MeasureDto::getComponentUuid, MeasureDto::getData)));
    }

    static class Builder {
        private List<ComponentDto> projects;
        private List<ComponentLinkDto> projectLinks;
        private List<SnapshotDto> snapshots;
        private List<MeasureDto> qualityGates;
        private Integer totalNbOfProjects;

        private Builder() {
        }

        Builder setProjects(List<ComponentDto> projects) {
            this.projects = projects;
            return this;
        }

        public Builder setProjectLinks(List<ComponentLinkDto> projectLinks) {
            this.projectLinks = projectLinks;
            return this;
        }

        public Builder setSnapshots(List<SnapshotDto> snapshots) {
            this.snapshots = snapshots;
            return this;
        }

        public Builder setQualityGates(List<MeasureDto> qGateStatuses) {
            this.qualityGates = qGateStatuses;
            return this;
        }

        public Builder setTotalNbOfProjects(Integer totalNbOfProjects) {
            this.totalNbOfProjects = totalNbOfProjects;
            return this;
        }

        SearchMyProjectsData build() {
            Objects.requireNonNull(this.projects);
            Objects.requireNonNull(this.projectLinks);
            Objects.requireNonNull(this.snapshots);
            Objects.requireNonNull(this.qualityGates);
            Objects.requireNonNull(this.totalNbOfProjects);
            return new SearchMyProjectsData(this);
        }
    }
}

