/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.picocontainer.Startable;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.plugins.ServerPluginRepository;

public abstract class AbstractPluginUninstaller
implements Startable {
    private static final String PLUGIN_EXTENSION = "jar";
    private final ServerPluginRepository serverPluginRepository;
    private final File uninstallDir;

    protected AbstractPluginUninstaller(ServerPluginRepository serverPluginRepository, File uninstallDir) {
        this.serverPluginRepository = serverPluginRepository;
        this.uninstallDir = uninstallDir;
    }

    public void start() {
        try {
            FileUtils.forceMkdir((File)this.uninstallDir);
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to create the directory: " + this.uninstallDir, e);
        }
    }

    public void stop() {
    }

    public void uninstall(String pluginKey) {
        this.ensurePluginIsInstalled(pluginKey);
        this.serverPluginRepository.uninstall(pluginKey, this.uninstallDir);
    }

    public void cancelUninstalls() {
        this.serverPluginRepository.cancelUninstalls(this.uninstallDir);
    }

    public Collection<PluginInfo> getUninstalledPlugins() {
        return (Collection)AbstractPluginUninstaller.listJarFiles(this.uninstallDir).stream().map(PluginInfo::create).collect(MoreCollectors.toList());
    }

    private static Collection<File> listJarFiles(File dir) {
        if (dir.exists()) {
            return FileUtils.listFiles((File)dir, (String[])new String[]{PLUGIN_EXTENSION}, (boolean)false);
        }
        return Collections.emptyList();
    }

    private void ensurePluginIsInstalled(String key) {
        if (!this.serverPluginRepository.hasPlugin(key)) {
            throw new IllegalArgumentException(String.format("Plugin [%s] is not installed", key));
        }
    }
}

