/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.monitoring.cluster;

import javax.annotation.Nullable;
import org.sonar.api.server.ServerSide;
import org.sonar.ce.configuration.WorkerCountProvider;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.ce.CeQueueDto;
import org.sonar.process.systeminfo.Global;
import org.sonar.process.systeminfo.SystemInfoSection;
import org.sonar.process.systeminfo.SystemInfoUtils;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;

@ServerSide
public class CeQueueGlobalSection
implements SystemInfoSection,
Global {
    private static final int DEFAULT_NB_OF_WORKERS = 1;
    private final DbClient dbClient;
    @Nullable
    private final WorkerCountProvider workerCountProvider;

    public CeQueueGlobalSection(DbClient dbClient, @Nullable WorkerCountProvider workerCountProvider) {
        this.dbClient = dbClient;
        this.workerCountProvider = workerCountProvider;
    }

    public CeQueueGlobalSection(DbClient dbClient) {
        this(dbClient, null);
    }

    public ProtobufSystemInfo.Section toProtobuf() {
        ProtobufSystemInfo.Section.Builder protobuf = ProtobufSystemInfo.Section.newBuilder();
        protobuf.setName("Compute Engine Tasks");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Total Pending", (long)this.dbClient.ceQueueDao().countByStatus(dbSession, CeQueueDto.Status.PENDING));
            SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Total In Progress", (long)this.dbClient.ceQueueDao().countByStatus(dbSession, CeQueueDto.Status.IN_PROGRESS));
            SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Max Workers per Node", (long)(this.workerCountProvider == null ? 1L : (long)this.workerCountProvider.get()));
        }
        return protobuf.build();
    }
}

