/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform;

import com.google.common.base.Preconditions;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.Startable;
import org.sonar.api.SonarQubeSide;
import org.sonar.api.SonarRuntime;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.property.PropertyDto;
import org.sonar.server.platform.ServerIdChecksum;
import org.sonar.server.platform.WebServer;

public class ServerIdManager
implements Startable {
    private static final Logger LOGGER = Loggers.get(ServerIdManager.class);
    private final Configuration config;
    private final DbClient dbClient;
    private final SonarRuntime runtime;
    private final WebServer webServer;
    private final UuidFactory uuidFactory;

    public ServerIdManager(Configuration config, DbClient dbClient, SonarRuntime runtime, WebServer webServer, UuidFactory uuidFactory) {
        this.config = config;
        this.dbClient = dbClient;
        this.runtime = runtime;
        this.webServer = webServer;
        this.uuidFactory = uuidFactory;
    }

    public void start() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            if (this.runtime.getSonarQubeSide() == SonarQubeSide.SERVER && this.webServer.isStartupLeader()) {
                if (this.needsToBeDropped(dbSession)) {
                    this.dbClient.propertiesDao().deleteGlobalProperty("sonar.core.id", dbSession);
                }
                this.persistServerIdIfMissing(dbSession);
                dbSession.commit();
            } else {
                this.ensureServerIdIsValid(dbSession);
            }
        }
    }

    private boolean needsToBeDropped(DbSession dbSession) {
        String expectedChecksum;
        PropertyDto dto = this.dbClient.propertiesDao().selectGlobalProperty(dbSession, "sonar.core.id");
        if (dto == null) {
            return false;
        }
        if (StringUtils.isEmpty((String)dto.getValue())) {
            return true;
        }
        if (ServerIdManager.isDate(dto.getValue())) {
            LOGGER.info("Server ID is changed to new format.");
            return true;
        }
        Optional checksum = this.dbClient.internalPropertiesDao().selectByKey(dbSession, "server.idChecksum");
        if (checksum.isPresent() && !(expectedChecksum = this.computeChecksum(dto.getValue())).equals(checksum.get())) {
            LOGGER.warn("Server ID is reset because it is not valid anymore. Database URL probably changed. The new server ID affects SonarSource licensed products.");
            return true;
        }
        return false;
    }

    private void persistServerIdIfMissing(DbSession dbSession) {
        String serverId;
        PropertyDto idDto = this.dbClient.propertiesDao().selectGlobalProperty(dbSession, "sonar.core.id");
        if (idDto == null) {
            serverId = this.uuidFactory.create();
            this.dbClient.propertiesDao().saveProperty(dbSession, new PropertyDto().setKey("sonar.core.id").setValue(serverId));
        } else {
            serverId = idDto.getValue();
        }
        this.dbClient.internalPropertiesDao().save(dbSession, "server.idChecksum", this.computeChecksum(serverId));
    }

    private static boolean isDate(String value) {
        try {
            new SimpleDateFormat("yyyyMMddHHmmss").parse(value);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    private String computeChecksum(String serverId) {
        String jdbcUrl = (String)this.config.get("sonar.jdbc.url").orElseThrow(() -> new IllegalStateException("Missing JDBC URL"));
        return ServerIdChecksum.of(serverId, jdbcUrl);
    }

    private void ensureServerIdIsValid(DbSession dbSession) {
        PropertyDto id = this.dbClient.propertiesDao().selectGlobalProperty(dbSession, "sonar.core.id");
        Preconditions.checkState((id != null ? 1 : 0) != 0, (String)"Property %s is missing in database", (Object[])new Object[]{"sonar.core.id"});
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((String)id.getValue()), (String)"Property %s is empty in database", (Object[])new Object[]{"sonar.core.id"});
        Optional checksum = this.dbClient.internalPropertiesDao().selectByKey(dbSession, "server.idChecksum");
        Preconditions.checkState((boolean)checksum.isPresent(), (String)"Internal property %s is missing in database", (Object[])new Object[]{"server.idChecksum"});
        Preconditions.checkState((boolean)((String)checksum.get()).equals(this.computeChecksum(id.getValue())), (Object)"Server ID is invalid");
    }

    public void stop() {
    }
}

