/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.sonar.api.utils.Paging;
import org.sonar.db.component.ComponentDto;

class SearchProjectPermissionsData {
    private final List<ComponentDto> rootComponents;
    private final Paging paging;
    private final Table<Long, String, Integer> userCountByProjectIdAndPermission;
    private final Table<Long, String, Integer> groupCountByProjectIdAndPermission;

    private SearchProjectPermissionsData(Builder builder) {
        this.rootComponents = ImmutableList.copyOf((Collection)builder.projects);
        this.paging = builder.paging;
        this.userCountByProjectIdAndPermission = ImmutableTable.copyOf((Table)builder.userCountByProjectIdAndPermission);
        this.groupCountByProjectIdAndPermission = ImmutableTable.copyOf((Table)builder.groupCountByProjectIdAndPermission);
    }

    static Builder newBuilder() {
        return new Builder();
    }

    List<ComponentDto> rootComponents() {
        return this.rootComponents;
    }

    Paging paging() {
        return this.paging;
    }

    int userCount(long rootComponentId, String permission) {
        return (Integer)MoreObjects.firstNonNull((Object)this.userCountByProjectIdAndPermission.get((Object)rootComponentId, (Object)permission), (Object)0);
    }

    int groupCount(long rootComponentId, String permission) {
        return (Integer)MoreObjects.firstNonNull((Object)this.groupCountByProjectIdAndPermission.get((Object)rootComponentId, (Object)permission), (Object)0);
    }

    Set<String> permissions(long rootComponentId) {
        return FluentIterable.from((Iterable)Iterables.concat(this.userCountByProjectIdAndPermission.row((Object)rootComponentId).keySet(), this.groupCountByProjectIdAndPermission.row((Object)rootComponentId).keySet())).toSortedSet((Comparator)Ordering.natural());
    }

    static class Builder {
        private List<ComponentDto> projects;
        private Paging paging;
        private Table<Long, String, Integer> userCountByProjectIdAndPermission;
        private Table<Long, String, Integer> groupCountByProjectIdAndPermission;

        private Builder() {
        }

        SearchProjectPermissionsData build() {
            Preconditions.checkState((this.projects != null ? 1 : 0) != 0);
            Preconditions.checkState((this.userCountByProjectIdAndPermission != null ? 1 : 0) != 0);
            Preconditions.checkState((this.groupCountByProjectIdAndPermission != null ? 1 : 0) != 0);
            return new SearchProjectPermissionsData(this);
        }

        Builder rootComponents(List<ComponentDto> projects) {
            this.projects = projects;
            return this;
        }

        Builder paging(Paging paging) {
            this.paging = paging;
            return this;
        }

        Builder userCountByProjectIdAndPermission(Table<Long, String, Integer> userCountByProjectIdAndPermission) {
            this.userCountByProjectIdAndPermission = userCountByProjectIdAndPermission;
            return this;
        }

        Builder groupCountByProjectIdAndPermission(Table<Long, String, Integer> groupCountByProjectIdAndPermission) {
            this.groupCountByProjectIdAndPermission = groupCountByProjectIdAndPermission;
            return this;
        }
    }
}

