/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws;

import com.google.protobuf.Message;
import java.util.Locale;
import java.util.Optional;
import org.sonar.api.i18n.I18n;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Paging;
import org.sonar.core.permission.ProjectPermissions;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.ProjectId;
import org.sonar.server.permission.ws.PermissionRequestValidator;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.PermissionsWsParametersBuilder;
import org.sonar.server.permission.ws.ProjectWsRef;
import org.sonar.server.permission.ws.SearchProjectPermissionsData;
import org.sonar.server.permission.ws.SearchProjectPermissionsDataLoader;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsParameterBuilder;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.WsPermissions;
import org.sonarqube.ws.client.permission.SearchProjectPermissionsWsRequest;

public class SearchProjectPermissionsAction
implements PermissionsWsAction {
    private static final String PROPERTY_PREFIX = "projects_role.";
    private static final String DESCRIPTION_SUFFIX = ".desc";
    private final DbClient dbClient;
    private final UserSession userSession;
    private final I18n i18n;
    private final ResourceTypes resourceTypes;
    private final SearchProjectPermissionsDataLoader dataLoader;
    private final PermissionWsSupport wsSupport;

    public SearchProjectPermissionsAction(DbClient dbClient, UserSession userSession, I18n i18n, ResourceTypes resourceTypes, SearchProjectPermissionsDataLoader dataLoader, PermissionWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.i18n = i18n;
        this.resourceTypes = resourceTypes;
        this.dataLoader = dataLoader;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search_project_permissions").setDescription("List project permissions. A project can be a technical project, a view or a developer.<br />Requires one of the following permissions:<ul><li>'Administer System'</li><li>'Administer' rights on the specified project</li></ul>").setResponseExample(this.getClass().getResource("search_project_permissions-example.json")).setSince("5.2").setDeprecatedSince("6.5").addPagingParams(25).setHandler((RequestHandler)this);
        action.createParam("q").setDescription("Limit search to: <ul><li>project names that contain the supplied string</li><li>project keys that are exactly the same as the supplied string</li></ul>").setExampleValue((Object)"apac");
        PermissionsWsParametersBuilder.createProjectParameters(action);
        WsParameterBuilder.createRootQualifierParameter(action, WsParameterBuilder.QualifierParameterContext.newQualifierParameterContext(this.i18n, this.resourceTypes)).setSince("5.3");
    }

    public void handle(Request wsRequest, Response wsResponse) throws Exception {
        WsPermissions.SearchProjectPermissionsWsResponse searchProjectPermissionsWsResponse = this.doHandle(SearchProjectPermissionsAction.toSearchProjectPermissionsWsRequest(wsRequest));
        WsUtils.writeProtobuf((Message)searchProjectPermissionsWsResponse, wsRequest, wsResponse);
    }

    private WsPermissions.SearchProjectPermissionsWsResponse doHandle(SearchProjectPermissionsWsRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.checkAuthorized(dbSession, request);
            PermissionRequestValidator.validateQualifier(request.getQualifier(), this.resourceTypes);
            SearchProjectPermissionsData data = this.dataLoader.load(dbSession, request);
            WsPermissions.SearchProjectPermissionsWsResponse searchProjectPermissionsWsResponse = this.buildResponse(data);
            return searchProjectPermissionsWsResponse;
        }
    }

    private static SearchProjectPermissionsWsRequest toSearchProjectPermissionsWsRequest(Request request) {
        return new SearchProjectPermissionsWsRequest().setProjectId(request.param("projectId")).setProjectKey(request.param("projectKey")).setQualifier(request.param("qualifier")).setPage(request.mandatoryParamAsInt("p")).setPageSize(request.mandatoryParamAsInt("ps")).setQuery(request.param("q"));
    }

    private void checkAuthorized(DbSession dbSession, SearchProjectPermissionsWsRequest request) {
        com.google.common.base.Optional<ProjectWsRef> projectRef = ProjectWsRef.newOptionalWsProjectRef(request.getProjectId(), request.getProjectKey());
        if (projectRef.isPresent()) {
            ComponentDto project = this.wsSupport.getRootComponentOrModule(dbSession, (ProjectWsRef)projectRef.get());
            PermissionPrivilegeChecker.checkProjectAdmin(this.userSession, project.getOrganizationUuid(), Optional.of(new ProjectId(project)));
        } else {
            this.userSession.checkLoggedIn().checkIsSystemAdministrator();
        }
    }

    private WsPermissions.SearchProjectPermissionsWsResponse buildResponse(SearchProjectPermissionsData data) {
        WsPermissions.SearchProjectPermissionsWsResponse.Builder response = WsPermissions.SearchProjectPermissionsWsResponse.newBuilder();
        WsPermissions.Permission.Builder permissionResponse = WsPermissions.Permission.newBuilder();
        WsPermissions.SearchProjectPermissionsWsResponse.Project.Builder rootComponentBuilder = WsPermissions.SearchProjectPermissionsWsResponse.Project.newBuilder();
        for (ComponentDto rootComponent : data.rootComponents()) {
            rootComponentBuilder.clear().setId(rootComponent.uuid()).setKey(rootComponent.getDbKey()).setQualifier(rootComponent.qualifier()).setName(rootComponent.name());
            for (String permission : data.permissions(rootComponent.getId())) {
                rootComponentBuilder.addPermissions(permissionResponse.clear().setKey(permission).setUsersCount(data.userCount(rootComponent.getId(), permission)).setGroupsCount(data.groupCount(rootComponent.getId(), permission)));
            }
            response.addProjects(rootComponentBuilder);
        }
        for (String permissionKey : ProjectPermissions.ALL) {
            response.addPermissions(permissionResponse.clear().setKey(permissionKey).setName(this.i18nName(permissionKey)).setDescription(this.i18nDescriptionMessage(permissionKey)));
        }
        Paging paging = data.paging();
        response.setPaging(Common.Paging.newBuilder().setPageIndex(paging.pageIndex()).setPageSize(paging.pageSize()).setTotal(paging.total()));
        return response.build();
    }

    private String i18nDescriptionMessage(String permissionKey) {
        return this.i18n.message(Locale.ENGLISH, PROPERTY_PREFIX + permissionKey + DESCRIPTION_SUFFIX, "", new Object[0]);
    }

    private String i18nName(String permissionKey) {
        return this.i18n.message(Locale.ENGLISH, PROPERTY_PREFIX + permissionKey, permissionKey, new Object[0]);
    }
}

