/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.notification;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.notifications.Notification;
import org.sonar.api.notifications.NotificationChannel;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.DbClient;
import org.sonar.server.notification.NotificationDispatcher;

@ServerSide
@ComputeEngineSide
public class NotificationService {
    private static final Logger LOG = Loggers.get(NotificationService.class);
    private final List<NotificationDispatcher> dispatchers;
    private final DbClient dbClient;

    public NotificationService(DbClient dbClient, NotificationDispatcher[] dispatchers) {
        this.dbClient = dbClient;
        this.dispatchers = ImmutableList.copyOf((Object[])dispatchers);
    }

    public NotificationService(DbClient dbClient) {
        this(dbClient, new NotificationDispatcher[0]);
    }

    public void deliver(Notification notification) {
        HashMultimap recipients = HashMultimap.create();
        for (NotificationDispatcher dispatcher : this.dispatchers) {
            ContextImpl context = new ContextImpl((Multimap<String, NotificationChannel>)recipients);
            try {
                dispatcher.performDispatch(notification, context);
            }
            catch (Exception e) {
                LOG.warn(String.format("Unable to dispatch notification %s using %s", notification, dispatcher), (Throwable)e);
            }
        }
        NotificationService.dispatch(notification, (SetMultimap<String, NotificationChannel>)recipients);
    }

    private static void dispatch(Notification notification, SetMultimap<String, NotificationChannel> recipients) {
        for (Map.Entry entry : recipients.asMap().entrySet()) {
            String username = (String)entry.getKey();
            Collection userChannels = (Collection)entry.getValue();
            LOG.debug("For user {} via {}", (Object)username, (Object)userChannels);
            for (NotificationChannel channel : userChannels) {
                try {
                    channel.deliver(notification, username);
                }
                catch (Exception e) {
                    LOG.warn("Unable to deliver notification " + notification + " for user " + username + " via " + channel, (Throwable)e);
                }
            }
        }
    }

    @VisibleForTesting
    List<NotificationDispatcher> getDispatchers() {
        return this.dispatchers;
    }

    public boolean hasProjectSubscribersForTypes(String projectUuid, Set<String> notificationTypes) {
        ArrayList<String> dispatcherKeys = new ArrayList<String>();
        for (NotificationDispatcher dispatcher : this.dispatchers) {
            if (!notificationTypes.contains(dispatcher.getType())) continue;
            dispatcherKeys.add(dispatcher.getKey());
        }
        return this.dbClient.propertiesDao().hasProjectNotificationSubscribersForDispatchers(projectUuid, dispatcherKeys);
    }

    private static class ContextImpl
    implements NotificationDispatcher.Context {
        private final Multimap<String, NotificationChannel> recipients;

        ContextImpl(Multimap<String, NotificationChannel> recipients) {
            this.recipients = recipients;
        }

        @Override
        public void addUser(@Nullable String userLogin, NotificationChannel notificationChannel) {
            if (userLogin != null) {
                this.recipients.put((Object)userLogin, (Object)notificationChannel);
            }
        }
    }
}

