/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.protobuf.Message;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.util.Protobuf;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.component.SnapshotQuery;
import org.sonar.db.measure.MeasureDto;
import org.sonar.db.measure.PastMeasureQuery;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.measure.ws.MeasuresWsAction;
import org.sonar.server.measure.ws.SearchHistoryResponseFactory;
import org.sonar.server.measure.ws.SearchHistoryResult;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsMeasures;
import org.sonarqube.ws.client.measure.SearchHistoryRequest;

public class SearchHistoryAction
implements MeasuresWsAction {
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final UserSession userSession;

    public SearchHistoryAction(DbClient dbClient, ComponentFinder componentFinder, UserSession userSession) {
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.userSession = userSession;
    }

    private static SearchHistoryRequest toWsRequest(Request request) {
        return SearchHistoryRequest.builder().setComponent(request.mandatoryParam("component")).setBranch(request.param("branch")).setMetrics(request.mandatoryParamAsStrings("metrics")).setFrom(request.param("from")).setTo(request.param("to")).setPage(request.mandatoryParamAsInt("p")).setPageSize(request.mandatoryParamAsInt("ps")).build();
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search_history").setDescription("Search measures history of a component.<br>Measures are ordered chronologically.<br>Pagination applies to the number of measures for each metric.<br>Requires the following permission: 'Browse' on the specified component").setResponseExample(this.getClass().getResource("search_history-example.json")).setSince("6.3").setHandler((RequestHandler)this);
        action.createParam("component").setDescription("Component key").setRequired(true).setExampleValue((Object)"my_project");
        action.createParam("branch").setDescription("Branch key").setSince("6.6").setInternal(true).setExampleValue((Object)"feature/my_branch");
        action.createParam("metrics").setDescription("Comma-separated list of metric keys").setRequired(true).setExampleValue((Object)"ncloc,coverage,new_violations");
        action.createParam("from").setDescription("Filter measures created after the given date (inclusive). <br>Either a date (server timezone) or datetime can be provided").setExampleValue((Object)"2017-10-19 or 2017-10-19T13:00:00+0200");
        action.createParam("to").setDescription("Filter measures created before the given date (inclusive). <br>Either a date (server timezone) or datetime can be provided").setExampleValue((Object)"2017-10-19 or 2017-10-19T13:00:00+0200");
        action.addPagingParams(100, 1000);
    }

    public void handle(Request request, Response response) throws Exception {
        WsMeasures.SearchHistoryResponse searchHistoryResponse = (WsMeasures.SearchHistoryResponse)Stream.of(request).map(SearchHistoryAction::toWsRequest).map(this.search()).map(result -> new SearchHistoryResponseFactory((SearchHistoryResult)result).apply()).collect(MoreCollectors.toOneElement());
        WsUtils.writeProtobuf((Message)searchHistoryResponse, request, response);
    }

    private Function<SearchHistoryRequest, SearchHistoryResult> search() {
        return request -> {
            try (DbSession dbSession = this.dbClient.openSession(false);){
                ComponentDto component = this.searchComponent((SearchHistoryRequest)request, dbSession);
                SearchHistoryResult result = new SearchHistoryResult((SearchHistoryRequest)request).setComponent(component).setAnalyses(this.searchAnalyses(dbSession, (SearchHistoryRequest)request, component)).setMetrics(this.searchMetrics(dbSession, (SearchHistoryRequest)request));
                SearchHistoryResult searchHistoryResult = result.setMeasures(this.searchMeasures(dbSession, (SearchHistoryRequest)request, result));
                return searchHistoryResult;
            }
        };
    }

    private ComponentDto searchComponent(SearchHistoryRequest request, DbSession dbSession) {
        ComponentDto component = this.loadComponent(dbSession, request);
        this.userSession.checkComponentPermission("user", component);
        return component;
    }

    private List<MeasureDto> searchMeasures(DbSession dbSession, SearchHistoryRequest request, SearchHistoryResult result) {
        Date from = DateUtils.parseStartingDateOrDateTime((String)request.getFrom());
        Date to = DateUtils.parseEndingDateOrDateTime((String)request.getTo());
        PastMeasureQuery dbQuery = new PastMeasureQuery(result.getComponent().uuid(), (List)result.getMetrics().stream().map(MetricDto::getId).collect(MoreCollectors.toList()), from == null ? null : Long.valueOf(from.getTime()), to == null ? null : Long.valueOf(to.getTime() + 1000L));
        return this.dbClient.measureDao().selectPastMeasures(dbSession, dbQuery);
    }

    private List<SnapshotDto> searchAnalyses(DbSession dbSession, SearchHistoryRequest request, ComponentDto component) {
        SnapshotQuery dbQuery = new SnapshotQuery().setComponentUuid(component.projectUuid()).setStatus("P").setSort(SnapshotQuery.SORT_FIELD.BY_DATE, SnapshotQuery.SORT_ORDER.ASC);
        Protobuf.setNullable((Object)request.getFrom(), from -> dbQuery.setCreatedAfter(Long.valueOf(DateUtils.parseStartingDateOrDateTime((String)from).getTime())));
        Protobuf.setNullable((Object)request.getTo(), to -> dbQuery.setCreatedBefore(Long.valueOf(DateUtils.parseEndingDateOrDateTime((String)to).getTime() + 1000L)));
        return this.dbClient.snapshotDao().selectAnalysesByQuery(dbSession, dbQuery);
    }

    private List<MetricDto> searchMetrics(DbSession dbSession, SearchHistoryRequest request) {
        List metrics = this.dbClient.metricDao().selectByKeys(dbSession, request.getMetrics());
        if (request.getMetrics().size() > metrics.size()) {
            Set requestedMetrics = (Set)request.getMetrics().stream().collect(MoreCollectors.toSet());
            Set foundMetrics = (Set)metrics.stream().map(MetricDto::getKey).collect(MoreCollectors.toSet());
            ImmutableSet unfoundMetrics = Sets.difference((Set)requestedMetrics, (Set)foundMetrics).immutableCopy();
            throw new IllegalArgumentException(String.format("Metrics %s are not found", String.join((CharSequence)", ", (Iterable<? extends CharSequence>)unfoundMetrics)));
        }
        return metrics;
    }

    private ComponentDto loadComponent(DbSession dbSession, SearchHistoryRequest request) {
        String componentKey = request.getComponent();
        String branch = request.getBranch();
        if (branch != null) {
            return this.componentFinder.getByKeyAndBranch(dbSession, componentKey, branch);
        }
        return this.componentFinder.getByKey(dbSession, componentKey);
    }
}

