/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.index;

import org.sonar.api.config.Configuration;
import org.sonar.server.es.DefaultIndexSettingsElement;
import org.sonar.server.es.IndexDefinition;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.NewIndex;

public class ProjectMeasuresIndexDefinition
implements IndexDefinition {
    public static final IndexType INDEX_TYPE_PROJECT_MEASURES = new IndexType("projectmeasures", "projectmeasure");
    public static final String FIELD_UUID = "uuid";
    public static final String FIELD_ORGANIZATION_UUID = "organizationUuid";
    public static final String FIELD_KEY = "key";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_ANALYSED_AT = "analysedAt";
    public static final String FIELD_QUALITY_GATE_STATUS = "qualityGateStatus";
    public static final String FIELD_TAGS = "tags";
    public static final String FIELD_MEASURES = "measures";
    public static final String FIELD_MEASURES_KEY = "key";
    public static final String FIELD_MEASURES_VALUE = "value";
    public static final String FIELD_LANGUAGES = "languages";
    public static final String FIELD_NCLOC_LANGUAGE_DISTRIBUTION = "nclocLanguageDistribution";
    public static final String FIELD_DISTRIB_LANGUAGE = "language";
    public static final String FIELD_DISTRIB_NCLOC = "ncloc";
    private final Configuration config;

    public ProjectMeasuresIndexDefinition(Configuration settings) {
        this.config = settings;
    }

    @Override
    public void define(IndexDefinition.IndexDefinitionContext context) {
        NewIndex index = context.create(INDEX_TYPE_PROJECT_MEASURES.getIndex(), NewIndex.SettingsConfiguration.newBuilder(this.config).setRefreshInterval(-1).setDefaultNbOfShards(5).build());
        NewIndex.NewIndexType mapping = index.createType(INDEX_TYPE_PROJECT_MEASURES.getType()).requireProjectAuthorization();
        ((NewIndex.KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_UUID).disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ORGANIZATION_UUID).disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)((NewIndex.KeywordFieldBuilder)mapping.keywordFieldBuilder("key").disableNorms()).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        ((NewIndex.KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_NAME).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER, DefaultIndexSettingsElement.SEARCH_GRAMS_ANALYZER)).build();
        mapping.keywordFieldBuilder(FIELD_QUALITY_GATE_STATUS).build();
        mapping.keywordFieldBuilder(FIELD_TAGS).build();
        mapping.keywordFieldBuilder(FIELD_LANGUAGES).build();
        mapping.nestedFieldBuilder(FIELD_MEASURES).addKeywordField("key").addDoubleField(FIELD_MEASURES_VALUE).build();
        mapping.nestedFieldBuilder(FIELD_NCLOC_LANGUAGE_DISTRIBUTION).addKeywordField(FIELD_DISTRIB_LANGUAGE).addIntegerField(FIELD_DISTRIB_NCLOC).build();
        mapping.createDateTimeField(FIELD_ANALYSED_AT);
        mapping.setEnableSource(false);
    }
}

