/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.custom.ws;

import com.google.common.base.Joiner;
import org.sonar.api.measures.Metric;

class CustomMeasureValueDescription {
    private CustomMeasureValueDescription() {
    }

    static String measureValueDescription() {
        StringBuilder description = new StringBuilder("Measure value. Value type depends on metric type:");
        description.append("<ul>");
        for (Metric.ValueType metricType : Metric.ValueType.values()) {
            description.append("<li>");
            description.append(String.format("%s - %s", metricType.name(), CustomMeasureValueDescription.metricTypeWsDescription(metricType)));
            description.append("</li>");
        }
        description.append("</ul>");
        return description.toString();
    }

    private static String metricTypeWsDescription(Metric.ValueType metricType) {
        switch (metricType) {
            case BOOL: {
                return "the possible values are true or false";
            }
            case INT: 
            case MILLISEC: {
                return "type: integer";
            }
            case FLOAT: 
            case PERCENT: 
            case RATING: {
                return "type: double";
            }
            case LEVEL: {
                return "the possible values are " + CustomMeasureValueDescription.formattedMetricLevelNames();
            }
            case STRING: 
            case DATA: 
            case DISTRIB: {
                return "type: string";
            }
            case WORK_DUR: {
                return "long representing the number of minutes";
            }
        }
        return "metric type not supported";
    }

    private static String formattedMetricLevelNames() {
        return Joiner.on((String)", ").join((Iterable)Metric.Level.names());
    }
}

