/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.issue.IssueChangeDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.db.protobuf.DbIssues;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.es.Facets;
import org.sonar.server.issue.TransitionService;
import org.sonar.server.issue.ws.SearchAdditionalField;
import org.sonar.server.issue.ws.SearchResponseData;
import org.sonar.server.user.UserSession;

public class SearchResponseLoader {
    private final UserSession userSession;
    private final DbClient dbClient;
    private final TransitionService transitionService;

    public SearchResponseLoader(UserSession userSession, DbClient dbClient, TransitionService transitionService) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.transitionService = transitionService;
    }

    public SearchResponseData load(Collector collector, @Nullable Facets facets) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            SearchResponseData result = new SearchResponseData(this.dbClient.issueDao().selectByOrderedKeys(dbSession, collector.getIssueKeys()));
            collector.collect(result.getIssues());
            this.loadRules(collector, dbSession, result);
            this.loadComments(collector, dbSession, result);
            this.loadUsers(collector, dbSession, result);
            this.loadComponents(collector, dbSession, result);
            this.loadOrganizations(dbSession, result);
            this.loadActionsAndTransitions(collector, result);
            SearchResponseLoader.completeTotalEffortFromFacet(facets, result);
            SearchResponseData searchResponseData = result;
            return searchResponseData;
        }
    }

    public SearchResponseData load(SearchResponseData preloadedResponseData, Collector collector, @Nullable Facets facets) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            SearchResponseData result = new SearchResponseData(this.loadIssues(preloadedResponseData, collector, dbSession));
            collector.collect(result.getIssues());
            this.loadRules(preloadedResponseData, collector, dbSession, result);
            this.loadComments(collector, dbSession, result);
            this.loadUsers(preloadedResponseData, collector, dbSession, result);
            this.loadComponents(preloadedResponseData, collector, dbSession, result);
            this.loadOrganizations(dbSession, result);
            this.loadActionsAndTransitions(collector, result);
            SearchResponseLoader.completeTotalEffortFromFacet(facets, result);
            SearchResponseData searchResponseData = result;
            return searchResponseData;
        }
    }

    private List<IssueDto> loadIssues(SearchResponseData preloadedResponseData, Collector collector, DbSession dbSession) {
        List<IssueDto> preloadedIssues = preloadedResponseData.getIssues();
        Set preloadedIssueKeys = (Set)preloadedIssues.stream().map(IssueDto::getKey).collect(MoreCollectors.toSet((int)preloadedIssues.size()));
        ImmutableSet issueKeysToLoad = ImmutableSet.copyOf((Collection)Sets.difference((Set)ImmutableSet.copyOf(collector.getIssueKeys()), (Set)preloadedIssueKeys));
        if (issueKeysToLoad.isEmpty()) {
            return preloadedIssues;
        }
        List loadedIssues = this.dbClient.issueDao().selectByKeys(dbSession, (Collection)issueKeysToLoad);
        return (List)Stream.concat(preloadedIssues.stream(), loadedIssues.stream()).collect(MoreCollectors.toList((int)(preloadedIssues.size() + loadedIssues.size())));
    }

    private void loadUsers(SearchResponseData preloadedResponseData, Collector collector, DbSession dbSession, SearchResponseData result) {
        if (collector.contains(SearchAdditionalField.USERS)) {
            List preloadedUsers = (List)MoreObjects.firstNonNull(preloadedResponseData.getUsers(), Collections.emptyList());
            Set preloadedLogins = (Set)preloadedUsers.stream().map(UserDto::getLogin).collect(MoreCollectors.toSet((int)preloadedUsers.size()));
            Set requestedLogins = collector.get(SearchAdditionalField.USERS);
            ImmutableSet loginsToLoad = ImmutableSet.copyOf((Collection)Sets.difference(requestedLogins, (Set)preloadedLogins));
            if (loginsToLoad.isEmpty()) {
                result.setUsers(preloadedUsers);
            } else {
                List loadedUsers = this.dbClient.userDao().selectByLogins(dbSession, (Collection)loginsToLoad);
                result.setUsers((List)Stream.concat(preloadedUsers.stream(), loadedUsers.stream()).collect(MoreCollectors.toList((int)(preloadedUsers.size() + loadedUsers.size()))));
            }
        }
    }

    private void loadComponents(SearchResponseData preloadedResponseData, Collector collector, DbSession dbSession, SearchResponseData result) {
        Collection<ComponentDto> preloadedComponents = preloadedResponseData.getComponents();
        Set preloadedComponentUuids = (Set)preloadedComponents.stream().map(ComponentDto::uuid).collect(MoreCollectors.toSet((int)preloadedComponents.size()));
        ImmutableSet componentUuidsToLoad = ImmutableSet.copyOf((Collection)Sets.difference(collector.getComponentUuids(), (Set)preloadedComponentUuids));
        result.addComponents(preloadedComponents);
        if (!componentUuidsToLoad.isEmpty()) {
            result.addComponents(this.dbClient.componentDao().selectByUuids(dbSession, (Collection)componentUuidsToLoad));
        }
        result.addComponents(this.dbClient.componentDao().selectSubProjectsByComponentUuids(dbSession, collector.getComponentUuids()));
        this.addProjectUuids(collector, dbSession, result);
    }

    private void addProjectUuids(Collector collector, DbSession dbSession, SearchResponseData result) {
        Collection<ComponentDto> loadedComponents = result.getComponents();
        for (ComponentDto component : loadedComponents) {
            collector.addProjectUuid(component.projectUuid());
        }
        Set loadedProjectUuids = (Set)loadedComponents.stream().filter(cpt -> cpt.uuid().equals(cpt.projectUuid())).map(ComponentDto::uuid).collect(MoreCollectors.toSet());
        ImmutableSet projectUuidsToLoad = ImmutableSet.copyOf((Collection)Sets.difference(collector.getProjectUuids(), (Set)loadedProjectUuids));
        if (!projectUuidsToLoad.isEmpty()) {
            List projects = this.dbClient.componentDao().selectByUuids(dbSession, collector.getProjectUuids());
            result.addComponents(projects);
        }
    }

    private void loadRules(SearchResponseData preloadedResponseData, Collector collector, DbSession dbSession, SearchResponseData result) {
        if (collector.contains(SearchAdditionalField.RULES)) {
            List preloadedRules = (List)MoreObjects.firstNonNull(preloadedResponseData.getRules(), Collections.emptyList());
            Set preloaedRuleKeys = (Set)preloadedRules.stream().map(RuleDefinitionDto::getKey).collect(MoreCollectors.toSet());
            ImmutableSet ruleKeysToLoad = ImmutableSet.copyOf((Collection)Sets.difference(collector.get(SearchAdditionalField.RULES), (Set)preloaedRuleKeys));
            if (ruleKeysToLoad.isEmpty()) {
                result.setRules(preloadedResponseData.getRules());
            } else {
                List loadedRules = this.dbClient.ruleDao().selectDefinitionByKeys(dbSession, (Collection)ruleKeysToLoad);
                result.setRules((List)Stream.concat(preloadedRules.stream(), loadedRules.stream()).collect(MoreCollectors.toList((int)(preloadedRules.size() + loadedRules.size()))));
            }
        }
    }

    private void loadUsers(Collector collector, DbSession dbSession, SearchResponseData result) {
        if (collector.contains(SearchAdditionalField.USERS)) {
            result.setUsers(this.dbClient.userDao().selectByLogins(dbSession, collector.getList(SearchAdditionalField.USERS)));
        }
    }

    private void loadComments(Collector collector, DbSession dbSession, SearchResponseData result) {
        if (collector.contains(SearchAdditionalField.COMMENTS)) {
            List comments = this.dbClient.issueChangeDao().selectByTypeAndIssueKeys(dbSession, collector.getIssueKeys(), "comment");
            result.setComments(comments);
            for (IssueChangeDto comment : comments) {
                collector.add(SearchAdditionalField.USERS, comment.getUserLogin());
                if (!this.canEditOrDelete(comment)) continue;
                result.addUpdatableComment(comment.getKey());
            }
        }
    }

    private boolean canEditOrDelete(IssueChangeDto dto) {
        return this.userSession.isLoggedIn() && this.userSession.getLogin().equals(dto.getUserLogin());
    }

    private void loadRules(Collector collector, DbSession dbSession, SearchResponseData result) {
        if (collector.contains(SearchAdditionalField.RULES)) {
            result.setRules(this.dbClient.ruleDao().selectDefinitionByKeys(dbSession, collector.getList(SearchAdditionalField.RULES)));
        }
    }

    private void loadComponents(Collector collector, DbSession dbSession, SearchResponseData result) {
        result.addComponents(this.dbClient.componentDao().selectByUuids(dbSession, collector.getComponentUuids()));
        result.addComponents(this.dbClient.componentDao().selectSubProjectsByComponentUuids(dbSession, collector.getComponentUuids()));
        this.addProjectUuids(collector, dbSession, result);
    }

    private void loadOrganizations(DbSession dbSession, SearchResponseData result) {
        Collection<ComponentDto> components = result.getComponents();
        this.dbClient.organizationDao().selectByUuids(dbSession, (Set)components.stream().map(ComponentDto::getOrganizationUuid).collect(MoreCollectors.toSet())).forEach(result::addOrganization);
    }

    private void loadActionsAndTransitions(Collector collector, SearchResponseData result) {
        if (collector.contains(SearchAdditionalField.ACTIONS) || collector.contains(SearchAdditionalField.TRANSITIONS)) {
            Map componentsByProjectUuid = (Map)result.getComponents().stream().filter(ComponentDto::isRootProject).collect(MoreCollectors.uniqueIndex(ComponentDto::projectUuid));
            for (IssueDto dto : result.getIssues()) {
                if (collector.contains(SearchAdditionalField.ACTIONS)) {
                    ComponentDto project = (ComponentDto)componentsByProjectUuid.get(dto.getProjectUuid());
                    result.addActions(dto.getKey(), this.listAvailableActions(dto, project));
                }
                if (!collector.contains(SearchAdditionalField.TRANSITIONS)) continue;
                DefaultIssue issue = dto.toDefaultIssue();
                result.addTransitions(issue.key(), this.transitionService.listTransitions(issue));
            }
        }
    }

    private List<String> listAvailableActions(IssueDto issue, ComponentDto project) {
        ArrayList availableActions = Lists.newArrayList();
        String login = this.userSession.getLogin();
        if (login == null) {
            return Collections.emptyList();
        }
        availableActions.add("comment");
        if (issue.getResolution() != null) {
            return availableActions;
        }
        availableActions.add("assign");
        availableActions.add("set_tags");
        if (this.userSession.hasComponentPermission("issueadmin", project)) {
            availableActions.add("set_type");
            availableActions.add("set_severity");
        }
        return availableActions;
    }

    private static void completeTotalEffortFromFacet(@Nullable Facets facets, SearchResponseData result) {
        LinkedHashMap<String, Long> effortFacet;
        if (facets != null && (effortFacet = facets.get("effort")) != null) {
            result.setEffortTotal((Long)effortFacet.get("total"));
        }
    }

    public static class Collector {
        private final Set<SearchAdditionalField> fields;
        private final SetMultimap<SearchAdditionalField, Object> fieldValues = MultimapBuilder.enumKeys(SearchAdditionalField.class).hashSetValues().build();
        private final Set<String> componentUuids = new HashSet<String>();
        private final Set<String> projectUuids = new HashSet<String>();
        private final List<String> issueKeys;

        public Collector(Set<SearchAdditionalField> fields, List<String> issueKeys) {
            this.fields = fields;
            this.issueKeys = issueKeys;
        }

        void collect(List<IssueDto> issues) {
            for (IssueDto issue : issues) {
                this.componentUuids.add(issue.getComponentUuid());
                this.projectUuids.add(issue.getProjectUuid());
                this.add(SearchAdditionalField.RULES, issue.getRuleKey());
                this.add(SearchAdditionalField.USERS, issue.getAssignee());
                this.collectComponentsFromIssueLocations(issue);
            }
        }

        private void collectComponentsFromIssueLocations(IssueDto issue) {
            DbIssues.Locations locations = issue.parseLocations();
            if (locations != null) {
                for (DbIssues.Flow flow : locations.getFlowList()) {
                    for (DbIssues.Location location : flow.getLocationList()) {
                        if (!location.hasComponentId()) continue;
                        this.componentUuids.add(location.getComponentId());
                    }
                }
            }
        }

        public void add(SearchAdditionalField key, @Nullable Object value) {
            if (value != null) {
                this.fieldValues.put((Object)key, value);
            }
        }

        public void addComponentUuids(@Nullable Collection<String> uuids) {
            if (uuids != null) {
                this.componentUuids.addAll(uuids);
            }
        }

        public void addProjectUuid(String uuid) {
            this.projectUuids.add(uuid);
        }

        public void addProjectUuids(@Nullable Collection<String> uuids) {
            if (uuids != null) {
                this.projectUuids.addAll(uuids);
            }
        }

        public void addAll(SearchAdditionalField key, @Nullable Iterable values) {
            if (values != null) {
                for (Object value : values) {
                    this.add(key, value);
                }
            }
        }

        <T> Set<T> get(SearchAdditionalField key) {
            return this.fieldValues.get((Object)key);
        }

        <T> List<T> getList(SearchAdditionalField key) {
            return Lists.newArrayList(this.get(key));
        }

        boolean contains(SearchAdditionalField field) {
            return this.fields.contains((Object)field);
        }

        public List<String> getIssueKeys() {
            return this.issueKeys;
        }

        public Set<String> getComponentUuids() {
            return this.componentUuids;
        }

        public Set<String> getProjectUuids() {
            return this.projectUuids;
        }
    }
}

