/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.sonar.api.issue.DefaultTransitions;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.Severity;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.server.issue.Action;
import org.sonar.server.issue.IssueStorage;
import org.sonar.server.issue.notification.IssueChangeNotification;
import org.sonar.server.issue.webhook.IssueChangeWebhook;
import org.sonar.server.issue.ws.IssuesWsAction;
import org.sonar.server.notification.NotificationManager;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Issues;

public class BulkChangeAction
implements IssuesWsAction {
    private static final Logger LOG = Loggers.get(BulkChangeAction.class);
    private final System2 system2;
    private final UserSession userSession;
    private final DbClient dbClient;
    private final IssueStorage issueStorage;
    private final NotificationManager notificationService;
    private final List<Action> actions;
    private final IssueChangeWebhook issueChangeWebhook;

    public BulkChangeAction(System2 system2, UserSession userSession, DbClient dbClient, IssueStorage issueStorage, NotificationManager notificationService, List<Action> actions, IssueChangeWebhook issueChangeWebhook) {
        this.system2 = system2;
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.issueStorage = issueStorage;
        this.notificationService = notificationService;
        this.actions = actions;
        this.issueChangeWebhook = issueChangeWebhook;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("bulk_change").setDescription("Bulk change on issues.<br/>Requires authentication.").setSince("3.7").setChangelog(new Change[]{new Change("6.3", "'actions' parameter is ignored")}).setHandler((RequestHandler)this).setResponseExample(this.getClass().getResource("bulk_change-example.json")).setPost(true);
        action.createParam("issues").setDescription("Comma-separated list of issue keys").setRequired(true).setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy,AU-TpxcA-iU5OvuD2FLz");
        action.createParam("assign").setDescription("To assign the list of issues to a specific user (login), or un-assign all the issues").setExampleValue((Object)"john.smith").setDeprecatedKey("assign.assignee", "6.2");
        action.createParam("set_severity").setDescription("To change the severity of the list of issues").setExampleValue((Object)"BLOCKER").setPossibleValues((Collection)Severity.ALL).setDeprecatedKey("set_severity.severity", "6.2");
        action.createParam("set_type").setDescription("To change the type of the list of issues").setExampleValue((Object)RuleType.BUG).setPossibleValues((Collection)RuleType.names()).setSince("5.5").setDeprecatedKey("set_type.type", "6.2");
        action.createParam("plan").setDescription("In 5.5, action plans are dropped. Has no effect. To plan the list of issues to a specific action plan (key), or unlink all the issues from an action plan").setDeprecatedSince("5.5");
        action.createParam("do_transition").setDescription("Transition").setExampleValue((Object)"reopen").setPossibleValues((Collection)DefaultTransitions.ALL).setDeprecatedKey("do_transition.transition", "6.2");
        action.createParam("add_tags").setDescription("Add tags").setExampleValue((Object)"security,java8").setDeprecatedKey("add_tags.tags", "6.2");
        action.createParam("remove_tags").setDescription("Remove tags").setExampleValue((Object)"security,java8").setDeprecatedKey("remove_tags.tags", "6.2");
        action.createParam("comment").setDescription("To add a comment to a list of issues").setExampleValue((Object)"Here is my comment");
        action.createParam("sendNotifications").setSince("4.0").setBooleanPossibleValues().setDefaultValue((Object)"false");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Issues.BulkChangeWsResponse wsResponse = (Issues.BulkChangeWsResponse)Stream.of(request).map(this.loadData(dbSession)).map(this.executeBulkChange()).map(BulkChangeAction.toWsResponse()).collect(MoreCollectors.toOneElement());
            WsUtils.writeProtobuf((Message)wsResponse, request, response);
        }
    }

    private Function<Request, BulkChangeData> loadData(DbSession dbSession) {
        return request -> new BulkChangeData(dbSession, (Request)request);
    }

    private Function<BulkChangeData, BulkChangeResult> executeBulkChange() {
        return bulkChangeData -> {
            BulkChangeResult result = new BulkChangeResult(((BulkChangeData)bulkChangeData).issues.size());
            IssueChangeContext issueChangeContext = IssueChangeContext.createUser((Date)new Date(this.system2.now()), (String)this.userSession.getLogin());
            List items = (List)((BulkChangeData)bulkChangeData).issues.stream().filter(BulkChangeAction.bulkChange(issueChangeContext, bulkChangeData, result)).collect(MoreCollectors.toList());
            this.issueStorage.save(items);
            items.forEach(this.sendNotification(issueChangeContext, (BulkChangeData)bulkChangeData));
            BulkChangeAction.buildWebhookIssueChange(((BulkChangeData)bulkChangeData).propertiesByActions).ifPresent(issueChange -> this.issueChangeWebhook.onChange(new IssueChangeWebhook.IssueChangeData((List)((BulkChangeData)bulkChangeData).issues.stream().filter(i -> result.success.contains(i.key())).collect(MoreCollectors.toList()), (List<ComponentDto>)ImmutableList.copyOf(((BulkChangeData)bulkChangeData).componentsByUuid.values())), (IssueChangeWebhook.IssueChange)issueChange, issueChangeContext));
            return result;
        };
    }

    private static Optional<IssueChangeWebhook.IssueChange> buildWebhookIssueChange(Map<String, Map<String, Object>> propertiesByActions) {
        RuleType ruleType = Optional.ofNullable(propertiesByActions.get("set_type")).map(t -> (String)t.get("type")).map(RuleType::valueOf).orElse(null);
        String transitionKey = Optional.ofNullable(propertiesByActions.get("do_transition")).map(t -> (String)t.get("transition")).orElse(null);
        if (ruleType == null && transitionKey == null) {
            return Optional.empty();
        }
        return Optional.of(new IssueChangeWebhook.IssueChange(ruleType, transitionKey));
    }

    private static Predicate<DefaultIssue> bulkChange(IssueChangeContext issueChangeContext, BulkChangeData bulkChangeData, BulkChangeResult result) {
        return issue -> {
            ActionContext actionContext = new ActionContext((DefaultIssue)issue, issueChangeContext, (ComponentDto)bulkChangeData.projectsByUuid.get(issue.projectUuid()));
            bulkChangeData.getActionsWithoutComment().forEach(BulkChangeAction.applyAction(actionContext, bulkChangeData, result));
            BulkChangeAction.addCommentIfNeeded(actionContext, bulkChangeData);
            return result.success.contains(issue.key());
        };
    }

    private static Consumer<Action> applyAction(ActionContext actionContext, BulkChangeData bulkChangeData, BulkChangeResult result) {
        return action -> {
            DefaultIssue issue = actionContext.issue();
            try {
                if (action.supports(issue) && action.execute(bulkChangeData.getProperties(action.key()), actionContext)) {
                    result.increaseSuccess(issue);
                }
            }
            catch (Exception e) {
                result.increaseFailure();
                LOG.error(String.format("An error occur when trying to apply the action : %s on issue : %s. This issue has been ignored. Error is '%s'", action.key(), issue.key(), e.getMessage()), (Throwable)e);
            }
        };
    }

    private static void addCommentIfNeeded(ActionContext actionContext, BulkChangeData bulkChangeData) {
        bulkChangeData.getCommentAction().ifPresent(action -> action.execute(bulkChangeData.getProperties(action.key()), actionContext));
    }

    private Consumer<DefaultIssue> sendNotification(IssueChangeContext issueChangeContext, BulkChangeData bulkChangeData) {
        return issue -> {
            if (bulkChangeData.sendNotification) {
                this.notificationService.scheduleForSending(new IssueChangeNotification().setIssue((DefaultIssue)issue).setChangeAuthorLogin(issueChangeContext.login()).setRuleName(((RuleDefinitionDto)bulkChangeData.rulesByKey.get(issue.ruleKey())).getName()).setProject((ComponentDto)bulkChangeData.projectsByUuid.get(issue.projectUuid())).setComponent((ComponentDto)bulkChangeData.componentsByUuid.get(issue.componentUuid())));
            }
        };
    }

    private static Function<BulkChangeResult, Issues.BulkChangeWsResponse> toWsResponse() {
        return bulkChangeResult -> Issues.BulkChangeWsResponse.newBuilder().setTotal((long)bulkChangeResult.getTotal()).setSuccess((long)bulkChangeResult.getSuccess()).setIgnored((long)bulkChangeResult.getTotal() - (long)(bulkChangeResult.getSuccess() + bulkChangeResult.getFailures())).setFailures((long)bulkChangeResult.getFailures()).build();
    }

    private static class BulkChangeResult {
        private final int total;
        private Set<String> success = new HashSet<String>();
        private int failures = 0;

        BulkChangeResult(int total) {
            this.total = total;
        }

        void increaseSuccess(DefaultIssue issue) {
            this.success.add(issue.key());
        }

        void increaseFailure() {
            ++this.failures;
        }

        public int getTotal() {
            return this.total;
        }

        public int getSuccess() {
            return this.success.size();
        }

        public int getFailures() {
            return this.failures;
        }
    }

    private class BulkChangeData {
        private final Map<String, Map<String, Object>> propertiesByActions;
        private final boolean sendNotification;
        private final Collection<DefaultIssue> issues;
        private final Map<String, ComponentDto> projectsByUuid;
        private final Map<String, ComponentDto> componentsByUuid;
        private final Map<RuleKey, RuleDefinitionDto> rulesByKey;
        private final List<Action> availableActions;

        BulkChangeData(DbSession dbSession, Request request) {
            this.sendNotification = request.mandatoryParamAsBoolean("sendNotifications");
            this.propertiesByActions = this.toPropertiesByActions(request);
            List issueKeys = request.mandatoryParamAsStrings("issues");
            Preconditions.checkArgument((issueKeys.size() <= 500 ? 1 : 0) != 0, (String)"Number of issues is limited to %s", (Object[])new Object[]{500});
            List allIssues = BulkChangeAction.this.dbClient.issueDao().selectByKeys(dbSession, (Collection)issueKeys);
            List<ComponentDto> allProjects = this.getComponents(dbSession, (Collection)allIssues.stream().map(IssueDto::getProjectUuid).collect(MoreCollectors.toSet()));
            this.projectsByUuid = (Map)this.getAuthorizedProjects(allProjects).stream().collect(MoreCollectors.uniqueIndex(ComponentDto::uuid, Function.identity()));
            this.issues = this.getAuthorizedIssues(allIssues);
            this.componentsByUuid = (Map)this.getComponents(dbSession, (Collection)this.issues.stream().map(DefaultIssue::componentUuid).collect(MoreCollectors.toSet())).stream().collect(MoreCollectors.uniqueIndex(ComponentDto::uuid, Function.identity()));
            this.rulesByKey = (Map)BulkChangeAction.this.dbClient.ruleDao().selectDefinitionByKeys(dbSession, (Collection)this.issues.stream().map(DefaultIssue::ruleKey).collect(MoreCollectors.toSet())).stream().collect(MoreCollectors.uniqueIndex(RuleDefinitionDto::getKey, Function.identity()));
            this.availableActions = (List)BulkChangeAction.this.actions.stream().filter(action -> this.propertiesByActions.containsKey(action.key())).filter(action -> action.verify(this.getProperties(action.key()), this.issues, BulkChangeAction.this.userSession)).collect(MoreCollectors.toList());
        }

        private List<ComponentDto> getComponents(DbSession dbSession, Collection<String> componentUuids) {
            return BulkChangeAction.this.dbClient.componentDao().selectByUuids(dbSession, componentUuids);
        }

        private List<ComponentDto> getAuthorizedProjects(List<ComponentDto> projectDtos) {
            return BulkChangeAction.this.userSession.keepAuthorizedComponents("user", projectDtos);
        }

        private List<DefaultIssue> getAuthorizedIssues(List<IssueDto> allIssues) {
            Set projectUuids = (Set)this.projectsByUuid.values().stream().map(ComponentDto::uuid).collect(MoreCollectors.toSet());
            return (List)allIssues.stream().filter(issue -> projectUuids.contains(issue.getProjectUuid())).map(IssueDto::toDefaultIssue).collect(MoreCollectors.toList());
        }

        Map<String, Object> getProperties(String actionKey) {
            return this.propertiesByActions.get(actionKey);
        }

        List<Action> getActionsWithoutComment() {
            return (List)this.availableActions.stream().filter(action -> !action.key().equals("comment")).collect(MoreCollectors.toList());
        }

        Optional<Action> getCommentAction() {
            return this.availableActions.stream().filter(action -> action.key().equals("comment")).findFirst();
        }

        private Map<String, Map<String, Object>> toPropertiesByActions(Request request) {
            HashMap<String, Map<String, Object>> properties = new HashMap<String, Map<String, Object>>();
            request.getParam("assign", value -> {
                Map cfr_ignored_0 = properties.put("assign", new HashMap(ImmutableMap.of((Object)"assignee", (Object)value)));
            });
            request.getParam("set_severity", value -> {
                Map cfr_ignored_0 = properties.put("set_severity", new HashMap(ImmutableMap.of((Object)"severity", (Object)value)));
            });
            request.getParam("set_type", value -> {
                Map cfr_ignored_0 = properties.put("set_type", new HashMap(ImmutableMap.of((Object)"type", (Object)value)));
            });
            request.getParam("do_transition", value -> {
                Map cfr_ignored_0 = properties.put("do_transition", new HashMap(ImmutableMap.of((Object)"transition", (Object)value)));
            });
            request.getParam("add_tags", value -> {
                Map cfr_ignored_0 = properties.put("add_tags", new HashMap(ImmutableMap.of((Object)"tags", (Object)value)));
            });
            request.getParam("remove_tags", value -> {
                Map cfr_ignored_0 = properties.put("remove_tags", new HashMap(ImmutableMap.of((Object)"tags", (Object)value)));
            });
            request.getParam("comment", value -> {
                Map cfr_ignored_0 = properties.put("comment", new HashMap(ImmutableMap.of((Object)"comment", (Object)value)));
            });
            this.checkAtLeastOneActionIsDefined(properties.keySet());
            return properties;
        }

        private void checkAtLeastOneActionIsDefined(Set<String> actions) {
            long actionsDefined = actions.stream().filter(action -> !action.equals("comment")).count();
            Preconditions.checkArgument((actionsDefined > 0L ? 1 : 0) != 0, (Object)"At least one action must be provided");
        }
    }

    public static class ActionContext
    implements Action.Context {
        private final DefaultIssue issue;
        private final IssueChangeContext changeContext;
        private final ComponentDto project;

        public ActionContext(DefaultIssue issue, IssueChangeContext changeContext, ComponentDto project) {
            this.issue = issue;
            this.changeContext = changeContext;
            this.project = project;
        }

        @Override
        public DefaultIssue issue() {
            return this.issue;
        }

        @Override
        public IssueChangeContext issueChangeContext() {
            return this.changeContext;
        }

        @Override
        public ComponentDto project() {
            return this.project;
        }
    }
}

