/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.server.issue.IssueStorage;
import org.sonar.server.issue.notification.IssueChangeNotification;
import org.sonar.server.issue.ws.SearchResponseData;
import org.sonar.server.notification.NotificationManager;

public class IssueUpdater {
    private final DbClient dbClient;
    private final IssueStorage issueStorage;
    private final NotificationManager notificationService;

    public IssueUpdater(DbClient dbClient, IssueStorage issueStorage, NotificationManager notificationService) {
        this.dbClient = dbClient;
        this.issueStorage = issueStorage;
        this.notificationService = notificationService;
    }

    public SearchResponseData saveIssueAndPreloadSearchResponseData(DbSession session, DefaultIssue issue, IssueChangeContext context, @Nullable String comment) {
        Optional<RuleDefinitionDto> rule = this.getRuleByKey(session, issue.getRuleKey());
        ComponentDto project = this.dbClient.componentDao().selectOrFailByUuid(session, issue.projectUuid());
        ComponentDto component = this.dbClient.componentDao().selectOrFailByUuid(session, issue.componentUuid());
        IssueDto issueDto = this.saveIssue(session, issue, context, comment, rule, project, component);
        SearchResponseData preloadedSearchResponseData = new SearchResponseData(issueDto);
        rule.ifPresent(r -> preloadedSearchResponseData.setRules(Collections.singletonList(r)));
        preloadedSearchResponseData.addComponents(Collections.singleton(project));
        preloadedSearchResponseData.addComponents(Collections.singleton(component));
        return preloadedSearchResponseData;
    }

    public IssueDto saveIssue(DbSession session, DefaultIssue issue, IssueChangeContext context, @Nullable String comment) {
        Optional<RuleDefinitionDto> rule = this.getRuleByKey(session, issue.getRuleKey());
        ComponentDto project = this.dbClient.componentDao().selectOrFailByUuid(session, issue.projectUuid());
        ComponentDto component = this.dbClient.componentDao().selectOrFailByUuid(session, issue.componentUuid());
        return this.saveIssue(session, issue, context, comment, rule, project, component);
    }

    private IssueDto saveIssue(DbSession session, DefaultIssue issue, IssueChangeContext context, @Nullable String comment, Optional<RuleDefinitionDto> rule, ComponentDto project, ComponentDto component) {
        IssueDto issueDto = this.issueStorage.save(session, issue);
        this.notificationService.scheduleForSending(new IssueChangeNotification().setIssue(issue).setChangeAuthorLogin(context.login()).setRuleName(rule.map(RuleDefinitionDto::getName).orElse(null)).setProject(project).setComponent(component).setComment(comment));
        return issueDto;
    }

    private Optional<RuleDefinitionDto> getRuleByKey(DbSession session, RuleKey ruleKey) {
        Optional<Object> rule = Optional.ofNullable(this.dbClient.ruleDao().selectDefinitionByKey(session, ruleKey).orElse(null));
        return rule.isPresent() && ((RuleDefinitionDto)rule.get()).getStatus() != RuleStatus.REMOVED ? rule : Optional.empty();
    }
}

