/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.sonar.api.rule.RuleKey;

public class IssueQuery {
    public static final String SORT_BY_CREATION_DATE = "CREATION_DATE";
    public static final String SORT_BY_UPDATE_DATE = "UPDATE_DATE";
    public static final String SORT_BY_CLOSE_DATE = "CLOSE_DATE";
    public static final String SORT_BY_ASSIGNEE = "ASSIGNEE";
    public static final String SORT_BY_SEVERITY = "SEVERITY";
    public static final String SORT_BY_STATUS = "STATUS";
    public static final String SORT_BY_FILE_LINE = "FILE_LINE";
    public static final Set<String> SORTS = ImmutableSet.of((Object)"CREATION_DATE", (Object)"UPDATE_DATE", (Object)"CLOSE_DATE", (Object)"ASSIGNEE", (Object)"SEVERITY", (Object)"STATUS", (Object[])new String[]{"FILE_LINE"});
    private final Collection<String> issueKeys;
    private final Collection<String> severities;
    private final Collection<String> statuses;
    private final Collection<String> resolutions;
    private final Collection<String> components;
    private final Collection<String> modules;
    private final Collection<String> moduleRoots;
    private final Collection<String> projects;
    private final Collection<String> directories;
    private final Collection<String> files;
    private final Collection<String> views;
    private final Collection<RuleKey> rules;
    private final Collection<String> assignees;
    private final Collection<String> authors;
    private final Collection<String> languages;
    private final Collection<String> tags;
    private final Collection<String> types;
    private final Map<String, PeriodStart> createdAfterByProjectUuids;
    private final Boolean onComponentOnly;
    private final Boolean assigned;
    private final Boolean resolved;
    private final Date createdAt;
    private final PeriodStart createdAfter;
    private final Date createdBefore;
    private final String sort;
    private final Boolean asc;
    private final String facetMode;
    private final String organizationUuid;
    private final String branchUuid;
    private final boolean mainBranch;
    private final boolean checkAuthorization;

    private IssueQuery(Builder builder) {
        this.issueKeys = IssueQuery.defaultCollection(builder.issueKeys);
        this.severities = IssueQuery.defaultCollection(builder.severities);
        this.statuses = IssueQuery.defaultCollection(builder.statuses);
        this.resolutions = IssueQuery.defaultCollection(builder.resolutions);
        this.components = IssueQuery.defaultCollection(builder.components);
        this.modules = IssueQuery.defaultCollection(builder.modules);
        this.moduleRoots = IssueQuery.defaultCollection(builder.moduleRoots);
        this.projects = IssueQuery.defaultCollection(builder.projects);
        this.directories = IssueQuery.defaultCollection(builder.directories);
        this.files = IssueQuery.defaultCollection(builder.files);
        this.views = IssueQuery.defaultCollection(builder.views);
        this.rules = IssueQuery.defaultCollection(builder.rules);
        this.assignees = IssueQuery.defaultCollection(builder.assignees);
        this.authors = IssueQuery.defaultCollection(builder.authors);
        this.languages = IssueQuery.defaultCollection(builder.languages);
        this.tags = IssueQuery.defaultCollection(builder.tags);
        this.types = IssueQuery.defaultCollection(builder.types);
        this.createdAfterByProjectUuids = IssueQuery.defaultMap(builder.createdAfterByProjectUuids);
        this.onComponentOnly = builder.onComponentOnly;
        this.assigned = builder.assigned;
        this.resolved = builder.resolved;
        this.createdAt = builder.createdAt;
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.sort = builder.sort;
        this.asc = builder.asc;
        this.checkAuthorization = builder.checkAuthorization;
        this.facetMode = builder.facetMode;
        this.organizationUuid = builder.organizationUuid;
        this.branchUuid = builder.branchUuid;
        this.mainBranch = builder.mainBranch;
    }

    public Collection<String> issueKeys() {
        return this.issueKeys;
    }

    public Collection<String> severities() {
        return this.severities;
    }

    public Collection<String> statuses() {
        return this.statuses;
    }

    public Collection<String> resolutions() {
        return this.resolutions;
    }

    public Collection<String> componentUuids() {
        return this.components;
    }

    public Collection<String> moduleUuids() {
        return this.modules;
    }

    public Collection<String> moduleRootUuids() {
        return this.moduleRoots;
    }

    public Collection<String> projectUuids() {
        return this.projects;
    }

    public Collection<String> directories() {
        return this.directories;
    }

    public Collection<String> fileUuids() {
        return this.files;
    }

    public Collection<String> viewUuids() {
        return this.views;
    }

    public Collection<RuleKey> rules() {
        return this.rules;
    }

    public Collection<String> assignees() {
        return this.assignees;
    }

    public Collection<String> authors() {
        return this.authors;
    }

    public Collection<String> languages() {
        return this.languages;
    }

    public Collection<String> tags() {
        return this.tags;
    }

    public Collection<String> types() {
        return this.types;
    }

    public Map<String, PeriodStart> createdAfterByProjectUuids() {
        return this.createdAfterByProjectUuids;
    }

    @CheckForNull
    public Boolean onComponentOnly() {
        return this.onComponentOnly;
    }

    @CheckForNull
    public Boolean assigned() {
        return this.assigned;
    }

    @CheckForNull
    public Boolean resolved() {
        return this.resolved;
    }

    @CheckForNull
    public PeriodStart createdAfter() {
        return this.createdAfter;
    }

    @CheckForNull
    public Date createdAt() {
        return this.createdAt == null ? null : new Date(this.createdAt.getTime());
    }

    @CheckForNull
    public Date createdBefore() {
        return this.createdBefore == null ? null : new Date(this.createdBefore.getTime());
    }

    @CheckForNull
    public String sort() {
        return this.sort;
    }

    @CheckForNull
    public Boolean asc() {
        return this.asc;
    }

    public boolean checkAuthorization() {
        return this.checkAuthorization;
    }

    @CheckForNull
    public String organizationUuid() {
        return this.organizationUuid;
    }

    @CheckForNull
    public String branchUuid() {
        return this.branchUuid;
    }

    public boolean isMainBranch() {
        return this.mainBranch;
    }

    public String facetMode() {
        return this.facetMode;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> Collection<T> defaultCollection(@Nullable Collection<T> c) {
        return c == null ? Collections.emptyList() : Collections.unmodifiableCollection(c);
    }

    private static <K, V> Map<K, V> defaultMap(@Nullable Map<K, V> map) {
        return map == null ? Collections.emptyMap() : Collections.unmodifiableMap(map);
    }

    public static class PeriodStart {
        private final Date date;
        private final boolean inclusive;

        public PeriodStart(Date date, boolean inclusive) {
            this.date = date;
            this.inclusive = inclusive;
        }

        public Date date() {
            return this.date;
        }

        public boolean inclusive() {
            return this.inclusive;
        }
    }

    public static class Builder {
        private Collection<String> issueKeys;
        private Collection<String> severities;
        private Collection<String> statuses;
        private Collection<String> resolutions;
        private Collection<String> components;
        private Collection<String> modules;
        private Collection<String> moduleRoots;
        private Collection<String> projects;
        private Collection<String> directories;
        private Collection<String> files;
        private Collection<String> views;
        private Collection<RuleKey> rules;
        private Collection<String> assignees;
        private Collection<String> authors;
        private Collection<String> languages;
        private Collection<String> tags;
        private Collection<String> types;
        private Map<String, PeriodStart> createdAfterByProjectUuids;
        private Boolean onComponentOnly = false;
        private Boolean assigned = null;
        private Boolean resolved = null;
        private Date createdAt;
        private PeriodStart createdAfter;
        private Date createdBefore;
        private String sort;
        private Boolean asc = false;
        private boolean checkAuthorization = true;
        private String facetMode;
        private String organizationUuid;
        private String branchUuid;
        private boolean mainBranch = true;

        private Builder() {
        }

        public Builder issueKeys(@Nullable Collection<String> l) {
            this.issueKeys = l;
            return this;
        }

        public Builder severities(@Nullable Collection<String> l) {
            this.severities = l;
            return this;
        }

        public Builder statuses(@Nullable Collection<String> l) {
            this.statuses = l;
            return this;
        }

        public Builder resolutions(@Nullable Collection<String> l) {
            this.resolutions = l;
            return this;
        }

        public Builder componentUuids(@Nullable Collection<String> l) {
            this.components = l;
            return this;
        }

        public Builder moduleUuids(@Nullable Collection<String> l) {
            this.modules = l;
            return this;
        }

        public Builder moduleRootUuids(@Nullable Collection<String> l) {
            this.moduleRoots = l;
            return this;
        }

        public Builder projectUuids(@Nullable Collection<String> l) {
            this.projects = l;
            return this;
        }

        public Builder directories(@Nullable Collection<String> l) {
            this.directories = l;
            return this;
        }

        public Builder fileUuids(@Nullable Collection<String> l) {
            this.files = l;
            return this;
        }

        public Builder viewUuids(@Nullable Collection<String> l) {
            this.views = l;
            return this;
        }

        public Builder rules(@Nullable Collection<RuleKey> rules) {
            this.rules = rules;
            return this;
        }

        public Builder assignees(@Nullable Collection<String> l) {
            this.assignees = l;
            return this;
        }

        public Builder authors(@Nullable Collection<String> l) {
            this.authors = l;
            return this;
        }

        public Builder languages(@Nullable Collection<String> l) {
            this.languages = l;
            return this;
        }

        public Builder tags(@Nullable Collection<String> t) {
            this.tags = t;
            return this;
        }

        public Builder types(@Nullable Collection<String> t) {
            this.types = t;
            return this;
        }

        public Builder createdAfterByProjectUuids(@Nullable Map<String, PeriodStart> createdAfterByProjectUuids) {
            this.createdAfterByProjectUuids = createdAfterByProjectUuids;
            return this;
        }

        public Builder onComponentOnly(@Nullable Boolean b) {
            this.onComponentOnly = b;
            return this;
        }

        public Builder assigned(@Nullable Boolean b) {
            this.assigned = b;
            return this;
        }

        public Builder resolved(@Nullable Boolean resolved) {
            this.resolved = resolved;
            return this;
        }

        public Builder createdAt(@Nullable Date d) {
            this.createdAt = d == null ? null : new Date(d.getTime());
            return this;
        }

        public Builder createdAfter(@Nullable Date d) {
            this.createdAfter(d, true);
            return this;
        }

        public Builder createdAfter(@Nullable Date d, boolean inclusive) {
            this.createdAfter = d == null ? null : new PeriodStart(new Date(d.getTime()), inclusive);
            return this;
        }

        public Builder createdBefore(@Nullable Date d) {
            this.createdBefore = d == null ? null : new Date(d.getTime());
            return this;
        }

        public Builder sort(@Nullable String s) {
            if (s != null && !SORTS.contains(s)) {
                throw new IllegalArgumentException("Bad sort field: " + s);
            }
            this.sort = s;
            return this;
        }

        public Builder asc(@Nullable Boolean asc) {
            this.asc = asc;
            return this;
        }

        public IssueQuery build() {
            if (this.issueKeys != null) {
                Preconditions.checkArgument((this.issueKeys.size() <= 500 ? 1 : 0) != 0, (Object)("Number of issue keys must be less than 500 (got " + this.issueKeys.size() + ")"));
            }
            return new IssueQuery(this);
        }

        public Builder checkAuthorization(boolean checkAuthorization) {
            this.checkAuthorization = checkAuthorization;
            return this;
        }

        public Builder facetMode(String facetMode) {
            this.facetMode = facetMode;
            return this;
        }

        public Builder organizationUuid(String s) {
            this.organizationUuid = s;
            return this;
        }

        public Builder branchUuid(@Nullable String s) {
            this.branchUuid = s;
            return this;
        }

        public Builder mainBranch(boolean mainBranch) {
            this.mainBranch = mainBranch;
            return this;
        }
    }
}

