/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.favorite.ws;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Paging;
import org.sonar.core.util.Protobuf;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.favorite.FavoriteFinder;
import org.sonar.server.favorite.ws.FavoritesWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Favorites;
import org.sonarqube.ws.client.favorite.SearchRequest;

public class SearchAction
implements FavoritesWsAction {
    private final FavoriteFinder favoriteFinder;
    private final DbClient dbClient;
    private final UserSession userSession;

    public SearchAction(FavoriteFinder favoriteFinder, DbClient dbClient, UserSession userSession) {
        this.favoriteFinder = favoriteFinder;
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search").setDescription("Search for the authenticated user favorites.<br>Requires authentication.").setSince("6.3").setResponseExample(this.getClass().getResource("search-example.json")).setHandler((RequestHandler)this);
        action.addPagingParams(100, 500);
    }

    public void handle(Request request, Response response) throws Exception {
        SearchRequest searchRequest = SearchAction.toWsRequest(request);
        SearchResults searchResults = this.toSearchResults(searchRequest);
        Favorites.SearchResponse wsResponse = SearchAction.toSearchResponse(searchResults);
        WsUtils.writeProtobuf((Message)wsResponse, request, response);
    }

    private static SearchRequest toWsRequest(Request request) {
        return new SearchRequest().setPage(Integer.valueOf(request.mandatoryParamAsInt("p"))).setPageSize(Integer.valueOf(request.mandatoryParamAsInt("ps")));
    }

    private SearchResults toSearchResults(SearchRequest request) {
        this.userSession.checkLoggedIn();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List<ComponentDto> authorizedFavorites = this.getAuthorizedFavorites();
            Paging paging = Paging.forPageIndex((int)request.getPage()).withPageSize(request.getPageSize().intValue()).andTotal(authorizedFavorites.size());
            List displayedFavorites = (List)authorizedFavorites.stream().skip(paging.offset()).limit(paging.pageSize()).collect(MoreCollectors.toList());
            Map<String, OrganizationDto> organizationsByUuid = this.getOrganizationsOfComponents(dbSession, displayedFavorites);
            SearchResults searchResults = new SearchResults(paging, displayedFavorites, organizationsByUuid);
            return searchResults;
        }
    }

    private List<ComponentDto> getAuthorizedFavorites() {
        List<ComponentDto> componentDtos = this.favoriteFinder.list();
        return this.userSession.keepAuthorizedComponents("user", componentDtos);
    }

    private Map<String, OrganizationDto> getOrganizationsOfComponents(DbSession dbSession, List<ComponentDto> displayedFavorites) {
        Set organizationUuids = (Set)displayedFavorites.stream().map(ComponentDto::getOrganizationUuid).collect(MoreCollectors.toSet());
        return (Map)this.dbClient.organizationDao().selectByUuids(dbSession, organizationUuids).stream().collect(MoreCollectors.uniqueIndex(OrganizationDto::getUuid));
    }

    private static Favorites.SearchResponse toSearchResponse(SearchResults searchResults) {
        Favorites.SearchResponse.Builder builder = Favorites.SearchResponse.newBuilder();
        SearchAction.addPaging(builder, searchResults);
        SearchAction.addFavorites(builder, searchResults);
        return builder.build();
    }

    private static void addPaging(Favorites.SearchResponse.Builder builder, SearchResults results) {
        builder.setPaging(Common.Paging.newBuilder().setPageIndex(results.paging.pageIndex()).setPageSize(results.paging.pageSize()).setTotal(results.paging.total()));
    }

    private static void addFavorites(Favorites.SearchResponse.Builder builder, SearchResults results) {
        Favorites.Favorite.Builder favoriteBuilder = Favorites.Favorite.newBuilder();
        results.favorites.stream().map(componentDto -> SearchAction.toWsFavorite(favoriteBuilder, results, componentDto)).forEach(arg_0 -> ((Favorites.SearchResponse.Builder)builder).addFavorites(arg_0));
    }

    private static Favorites.Favorite toWsFavorite(Favorites.Favorite.Builder builder, SearchResults results, ComponentDto componentDto) {
        OrganizationDto organization = (OrganizationDto)results.organizationsByUuid.get(componentDto.getOrganizationUuid());
        Preconditions.checkArgument((organization != null ? 1 : 0) != 0, (String)"Organization with uuid '%s' not found for favorite with uuid '%s'", (Object[])new Object[]{componentDto.getOrganizationUuid(), componentDto.uuid()});
        builder.clear().setOrganization(organization.getKey()).setKey(componentDto.getDbKey());
        Protobuf.setNullable((Object)componentDto.name(), arg_0 -> ((Favorites.Favorite.Builder)builder).setName(arg_0));
        Protobuf.setNullable((Object)componentDto.qualifier(), arg_0 -> ((Favorites.Favorite.Builder)builder).setQualifier(arg_0));
        return builder.build();
    }

    private static class SearchResults {
        private final List<ComponentDto> favorites;
        private final Paging paging;
        private final Map<String, OrganizationDto> organizationsByUuid;

        private SearchResults(Paging paging, List<ComponentDto> favorites, Map<String, OrganizationDto> organizationsByUuid) {
            this.paging = paging;
            this.favorites = favorites;
            this.organizationsByUuid = organizationsByUuid;
        }
    }
}

