/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.exceptions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.sonar.server.exceptions.ServerException;

public class BadRequestException
extends ServerException {
    private final transient List<String> errors;

    private BadRequestException(List<String> errors) {
        super(400, errors.get(0));
        this.errors = errors;
    }

    public static BadRequestException create(List<String> errorMessages) {
        Preconditions.checkArgument((!errorMessages.isEmpty() ? 1 : 0) != 0, (Object)"At least one error message is required");
        Preconditions.checkArgument((boolean)errorMessages.stream().noneMatch(message -> message == null || message.isEmpty()), (Object)"Message cannot be empty");
        return new BadRequestException(errorMessages);
    }

    public static BadRequestException create(String ... errorMessages) {
        return BadRequestException.create(Arrays.asList(errorMessages));
    }

    public List<String> errors() {
        return this.errors;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("errors", this.errors).toString();
    }
}

