/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.request;

import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsAction;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsRequest;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsRequestBuilder;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Profiler;
import org.sonar.server.es.EsClient;

public class ProxyClusterStatsRequestBuilder
extends ClusterStatsRequestBuilder {
    public ProxyClusterStatsRequestBuilder(Client client) {
        super((ElasticsearchClient)client.admin().cluster(), ClusterStatsAction.INSTANCE);
    }

    public ClusterStatsResponse get() {
        Profiler profiler = Profiler.createIfTrace((Logger)EsClient.LOGGER).start();
        try {
            ClusterStatsResponse clusterStatsResponse = (ClusterStatsResponse)super.execute().actionGet();
            return clusterStatsResponse;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to execute %s", this.toString()), e);
        }
        finally {
            if (profiler.isTraceEnabled()) {
                profiler.stopTrace(this.toString());
            }
        }
    }

    public ClusterStatsResponse get(TimeValue timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public ClusterStatsResponse get(String timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public ListenableActionFuture<ClusterStatsResponse> execute() {
        throw new UnsupportedOperationException("execute() should not be called as it's used for asynchronous");
    }

    public String toString() {
        StringBuilder message = new StringBuilder();
        message.append("ES cluster stats request");
        if (((ClusterStatsRequest)this.request).nodesIds() != null) {
            message.append(String.format(" on nodes '%s'", StringUtils.join((Object[])((ClusterStatsRequest)this.request).nodesIds(), (String)",")));
        }
        return message.toString();
    }
}

