/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import java.io.Closeable;
import java.util.Objects;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequestBuilder;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsRequestBuilder;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequestBuilder;
import org.elasticsearch.action.admin.indices.flush.FlushRequestBuilder;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequestBuilder;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.MultiGetRequestBuilder;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.Priority;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.max.Max;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.request.ProxyBulkRequestBuilder;
import org.sonar.server.es.request.ProxyClearCacheRequestBuilder;
import org.sonar.server.es.request.ProxyClusterHealthRequestBuilder;
import org.sonar.server.es.request.ProxyClusterStateRequestBuilder;
import org.sonar.server.es.request.ProxyClusterStatsRequestBuilder;
import org.sonar.server.es.request.ProxyCreateIndexRequestBuilder;
import org.sonar.server.es.request.ProxyDeleteRequestBuilder;
import org.sonar.server.es.request.ProxyFlushRequestBuilder;
import org.sonar.server.es.request.ProxyGetRequestBuilder;
import org.sonar.server.es.request.ProxyIndexRequestBuilder;
import org.sonar.server.es.request.ProxyIndicesExistsRequestBuilder;
import org.sonar.server.es.request.ProxyIndicesStatsRequestBuilder;
import org.sonar.server.es.request.ProxyMultiGetRequestBuilder;
import org.sonar.server.es.request.ProxyNodesStatsRequestBuilder;
import org.sonar.server.es.request.ProxyPutMappingRequestBuilder;
import org.sonar.server.es.request.ProxyRefreshRequestBuilder;
import org.sonar.server.es.request.ProxySearchRequestBuilder;
import org.sonar.server.es.request.ProxySearchScrollRequestBuilder;

public class EsClient
implements Closeable {
    public static final Logger LOGGER = Loggers.get((String)"es");
    private final Client nativeClient;

    public EsClient(Client nativeClient) {
        this.nativeClient = Objects.requireNonNull(nativeClient);
    }

    public EsClient() {
        this.nativeClient = null;
    }

    public RefreshRequestBuilder prepareRefresh(String ... indices) {
        return (RefreshRequestBuilder)new ProxyRefreshRequestBuilder(this.nativeClient()).setIndices(indices);
    }

    public FlushRequestBuilder prepareFlush(String ... indices) {
        return (FlushRequestBuilder)new ProxyFlushRequestBuilder(this.nativeClient()).setIndices(indices);
    }

    public IndicesStatsRequestBuilder prepareStats(String ... indices) {
        return (IndicesStatsRequestBuilder)new ProxyIndicesStatsRequestBuilder(this.nativeClient()).setIndices(indices);
    }

    public NodesStatsRequestBuilder prepareNodesStats(String ... nodesIds) {
        return (NodesStatsRequestBuilder)new ProxyNodesStatsRequestBuilder(this.nativeClient()).setNodesIds(nodesIds);
    }

    public ClusterStatsRequestBuilder prepareClusterStats() {
        return new ProxyClusterStatsRequestBuilder(this.nativeClient());
    }

    public ClusterStateRequestBuilder prepareState() {
        return new ProxyClusterStateRequestBuilder(this.nativeClient());
    }

    public ClusterHealthRequestBuilder prepareHealth(String ... indices) {
        return new ProxyClusterHealthRequestBuilder(this.nativeClient()).setIndices(indices);
    }

    public void waitForStatus(ClusterHealthStatus status) {
        this.prepareHealth(new String[0]).setWaitForEvents(Priority.LANGUID).setWaitForStatus(status).get();
    }

    public IndicesExistsRequestBuilder prepareIndicesExist(String ... indices) {
        return new ProxyIndicesExistsRequestBuilder(this.nativeClient(), indices);
    }

    public CreateIndexRequestBuilder prepareCreate(String index) {
        return new ProxyCreateIndexRequestBuilder(this.nativeClient(), index);
    }

    public PutMappingRequestBuilder preparePutMapping(String ... indices) {
        return new ProxyPutMappingRequestBuilder(this.nativeClient()).setIndices(indices);
    }

    public SearchRequestBuilder prepareSearch(String ... indices) {
        return new ProxySearchRequestBuilder(this.nativeClient()).setIndices(indices);
    }

    public SearchRequestBuilder prepareSearch(IndexType ... indexType) {
        return new ProxySearchRequestBuilder(this.nativeClient()).setIndices(IndexType.getIndices(indexType)).setTypes(IndexType.getTypes(indexType));
    }

    public SearchScrollRequestBuilder prepareSearchScroll(String scrollId) {
        return new ProxySearchScrollRequestBuilder(scrollId, this.nativeClient());
    }

    public GetRequestBuilder prepareGet() {
        return new ProxyGetRequestBuilder(this.nativeClient());
    }

    public GetRequestBuilder prepareGet(IndexType indexType, String id) {
        return ((GetRequestBuilder)new ProxyGetRequestBuilder(this.nativeClient()).setIndex(indexType.getIndex())).setType(indexType.getType()).setId(id);
    }

    public MultiGetRequestBuilder prepareMultiGet() {
        return new ProxyMultiGetRequestBuilder(this.nativeClient());
    }

    public BulkRequestBuilder prepareBulk() {
        return new ProxyBulkRequestBuilder(this.nativeClient());
    }

    public DeleteRequestBuilder prepareDelete(IndexType indexType, String id) {
        return new ProxyDeleteRequestBuilder(this.nativeClient(), indexType.getIndex()).setType(indexType.getType()).setId(id);
    }

    public DeleteRequestBuilder prepareDelete(String index, String type, String id) {
        return new ProxyDeleteRequestBuilder(this.nativeClient(), index).setType(type).setId(id);
    }

    public IndexRequestBuilder prepareIndex(IndexType indexType) {
        return ((IndexRequestBuilder)new ProxyIndexRequestBuilder(this.nativeClient()).setIndex(indexType.getIndex())).setType(indexType.getType());
    }

    public ForceMergeRequestBuilder prepareForceMerge(String indexName) {
        return this.nativeClient().admin().indices().prepareForceMerge(new String[]{indexName}).setMaxNumSegments(1);
    }

    public ClearIndicesCacheRequestBuilder prepareClearCache(String ... indices) {
        return (ClearIndicesCacheRequestBuilder)new ProxyClearCacheRequestBuilder(this.nativeClient()).setIndices(indices);
    }

    public long getMaxFieldValue(IndexType indexType, String fieldName) {
        SearchRequestBuilder request = this.prepareSearch(indexType).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setSize(0).addAggregation((AggregationBuilder)AggregationBuilders.max((String)"latest").field(fieldName));
        Max max = (Max)((SearchResponse)request.get()).getAggregations().get("latest");
        return (long)max.getValue();
    }

    public Client nativeClient() {
        return this.nativeClient;
    }

    public boolean isEmpty(IndexType indexType) {
        return this.count(indexType) <= 0L;
    }

    private long count(IndexType indexType) {
        return ((SearchResponse)this.prepareSearch(indexType).setSize(0).get()).getHits().getTotalHits();
    }

    @Override
    public void close() {
        this.nativeClient.close();
    }
}

