/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.duplication.ws;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.server.ServerSide;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDao;
import org.sonar.db.component.ComponentDto;

@ServerSide
public class DuplicationsParser {
    private final ComponentDao componentDao;

    public DuplicationsParser(ComponentDao componentDao) {
        this.componentDao = componentDao;
    }

    public List<Block> parse(DbSession session, ComponentDto component, @Nullable String branch, @Nullable String duplicationsData) {
        HashMap componentsByKey = Maps.newHashMap();
        ArrayList blocks = Lists.newArrayList();
        if (duplicationsData != null) {
            try {
                SMInputFactory inputFactory = DuplicationsParser.initStax();
                SMHierarchicCursor root = inputFactory.rootElementCursor((Reader)new StringReader(duplicationsData));
                root.advance();
                SMInputCursor cursor = root.childElementCursor("g");
                while (cursor.getNext() != null) {
                    ArrayList duplications = Lists.newArrayList();
                    SMInputCursor bCursor = cursor.childElementCursor("b");
                    while (bCursor.getNext() != null) {
                        String from = bCursor.getAttrValue("s");
                        String size = bCursor.getAttrValue("l");
                        String componentKey = bCursor.getAttrValue("r");
                        if (from == null || size == null || componentKey == null) continue;
                        duplications.add(this.createDuplication(componentsByKey, branch, from, size, componentKey, session));
                    }
                    Collections.sort(duplications, new DuplicationComparator(component.uuid(), component.projectUuid()));
                    blocks.add(new Block(duplications));
                }
                Collections.sort(blocks, new BlockComparator());
            }
            catch (XMLStreamException e) {
                throw new IllegalStateException("XML is not valid", e);
            }
        }
        return blocks;
    }

    private Duplication createDuplication(Map<String, ComponentDto> componentsByKey, @Nullable String branch, String from, String size, String componentDbKey, DbSession session) {
        String componentKey = DuplicationsParser.convertToKey(componentDbKey);
        ComponentDto component = componentsByKey.get(componentKey);
        if (component == null) {
            Optional componentDtoOptional = branch == null ? this.componentDao.selectByKey(session, componentKey) : Optional.fromNullable(this.componentDao.selectByKeyAndBranch(session, componentKey, branch).orElseGet(null));
            component = componentDtoOptional.isPresent() ? (ComponentDto)componentDtoOptional.get() : null;
            componentsByKey.put(componentKey, component);
        }
        return new Duplication(component, Integer.valueOf(from), Integer.valueOf(size));
    }

    private static String convertToKey(String dbKey) {
        return new ComponentDto().setDbKey(dbKey).getKey();
    }

    private static SMInputFactory initStax() {
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        xmlFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        return new SMInputFactory(xmlFactory);
    }

    static class Block {
        private final List<Duplication> duplications;

        public Block(List<Duplication> duplications) {
            this.duplications = duplications;
        }

        public List<Duplication> getDuplications() {
            return this.duplications;
        }
    }

    public static class Duplication {
        private final ComponentDto file;
        private final Integer from;
        private final Integer size;

        Duplication(@Nullable ComponentDto file, Integer from, Integer size) {
            this.file = file;
            this.from = from;
            this.size = size;
        }

        @CheckForNull
        ComponentDto file() {
            return this.file;
        }

        Integer from() {
            return this.from;
        }

        Integer size() {
            return this.size;
        }
    }

    private static class BlockComparator
    implements Comparator<Block>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private BlockComparator() {
        }

        @Override
        public int compare(@Nullable Block b1, @Nullable Block b2) {
            if (b1 == null || b2 == null) {
                return -1;
            }
            List<Duplication> duplications1 = b1.getDuplications();
            List<Duplication> duplications2 = b2.getDuplications();
            if (duplications1.isEmpty() || duplications2.isEmpty()) {
                return -1;
            }
            return duplications1.get(0).from().compareTo(duplications2.get(0).from());
        }
    }

    @VisibleForTesting
    static class DuplicationComparator
    implements Comparator<Duplication>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String uuid;
        private final String projectUuid;

        DuplicationComparator(String uuid, String projectUuid) {
            this.uuid = uuid;
            this.projectUuid = projectUuid;
        }

        @Override
        public int compare(@Nullable Duplication d1, @Nullable Duplication d2) {
            if (d1 == null || d2 == null) {
                return -1;
            }
            ComponentDto file1 = d1.file();
            ComponentDto file2 = d2.file();
            if (file1 == null || file2 == null) {
                return -1;
            }
            if (file1.equals((Object)d2.file())) {
                return d1.from().compareTo(d2.from());
            }
            if (file1.uuid().equals(this.uuid)) {
                return -1;
            }
            if (file2.uuid().equals(this.uuid)) {
                return 1;
            }
            if (StringUtils.equals((String)file1.projectUuid(), (String)this.projectUuid) && !StringUtils.equals((String)file2.projectUuid(), (String)this.projectUuid)) {
                return -1;
            }
            if (StringUtils.equals((String)file2.projectUuid(), (String)this.projectUuid) && !StringUtils.equals((String)file1.projectUuid(), (String)this.projectUuid)) {
                return 1;
            }
            return d1.from().compareTo(d2.from());
        }
    }
}

