/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.CloseableIterator;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.duplication.DuplicationUnitDto;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.block.ByteArray;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.server.computation.task.projectanalysis.analysis.Analysis;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.batch.BatchReportReader;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.duplication.CrossProjectDuplicationStatusHolder;
import org.sonar.server.computation.task.projectanalysis.duplication.IntegrateCrossProjectDuplications;
import org.sonar.server.computation.task.step.ComputationStep;

public class LoadCrossProjectDuplicationsRepositoryStep
implements ComputationStep {
    private static final Logger LOGGER = Loggers.get(LoadCrossProjectDuplicationsRepositoryStep.class);
    private final TreeRootHolder treeRootHolder;
    private final BatchReportReader reportReader;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final IntegrateCrossProjectDuplications integrateCrossProjectDuplications;
    private final CrossProjectDuplicationStatusHolder crossProjectDuplicationStatusHolder;
    private final DbClient dbClient;

    public LoadCrossProjectDuplicationsRepositoryStep(TreeRootHolder treeRootHolder, BatchReportReader reportReader, AnalysisMetadataHolder analysisMetadataHolder, CrossProjectDuplicationStatusHolder crossProjectDuplicationStatusHolder, IntegrateCrossProjectDuplications integrateCrossProjectDuplications, DbClient dbClient) {
        this.treeRootHolder = treeRootHolder;
        this.reportReader = reportReader;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.integrateCrossProjectDuplications = integrateCrossProjectDuplications;
        this.crossProjectDuplicationStatusHolder = crossProjectDuplicationStatusHolder;
        this.dbClient = dbClient;
    }

    @Override
    public void execute() {
        if (this.crossProjectDuplicationStatusHolder.isEnabled()) {
            new DepthTraversalTypeAwareCrawler(new CrossProjectDuplicationVisitor()).visit(this.treeRootHolder.getRoot());
        }
    }

    @Override
    public String getDescription() {
        return "Compute cross project duplications";
    }

    private static class CpdTextBlockToBlock
    implements Function<ScannerReport.CpdTextBlock, Block> {
        private final String fileKey;
        private int indexInFile = 0;

        public CpdTextBlockToBlock(String fileKey) {
            this.fileKey = fileKey;
        }

        public Block apply(@Nonnull ScannerReport.CpdTextBlock duplicationBlock) {
            Block block = Block.builder().setResourceId(this.fileKey).setBlockHash(new ByteArray(duplicationBlock.getHash())).setIndexInFile(this.indexInFile).setLines(duplicationBlock.getStartLine(), duplicationBlock.getEndLine()).setUnit(duplicationBlock.getStartTokenIndex(), duplicationBlock.getEndTokenIndex()).build();
            ++this.indexInFile;
            return block;
        }
    }

    private static enum DtoToBlock implements Function<DuplicationUnitDto, Block>
    {
        INSTANCE;


        public Block apply(@Nonnull DuplicationUnitDto dto) {
            return Block.builder().setResourceId(dto.getComponentKey()).setBlockHash(new ByteArray(dto.getHash())).setIndexInFile(dto.getIndexInFile()).setLines(dto.getStartLine(), dto.getEndLine()).build();
        }
    }

    private static enum CpdTextBlockToHash implements Function<ScannerReport.CpdTextBlock, String>
    {
        INSTANCE;


        public String apply(@Nonnull ScannerReport.CpdTextBlock duplicationBlock) {
            return duplicationBlock.getHash();
        }
    }

    private class CrossProjectDuplicationVisitor
    extends TypeAwareVisitorAdapter {
        private CrossProjectDuplicationVisitor() {
            super(CrawlerDepthLimit.FILE, ComponentVisitor.Order.PRE_ORDER);
        }

        @Override
        public void visitFile(Component file) {
            ArrayList cpdTextBlocks;
            try (CloseableIterator<ScannerReport.CpdTextBlock> blocksIt = LoadCrossProjectDuplicationsRepositoryStep.this.reportReader.readCpdTextBlocks(file.getReportAttributes().getRef());){
                cpdTextBlocks = Lists.newArrayList(blocksIt);
                LOGGER.trace("Found {} cpd blocks on file {}", (Object)cpdTextBlocks.size(), (Object)file.getKey());
                if (cpdTextBlocks.isEmpty()) {
                    return;
                }
            }
            ImmutableList hashes = FluentIterable.from((Iterable)cpdTextBlocks).transform((Function)CpdTextBlockToHash.INSTANCE).toList();
            List<DuplicationUnitDto> dtos = this.selectDuplicates(file, (Collection<String>)hashes);
            if (dtos.isEmpty()) {
                return;
            }
            ImmutableList duplicatedBlocks = FluentIterable.from(dtos).transform((Function)DtoToBlock.INSTANCE).toList();
            ImmutableList originBlocks = FluentIterable.from((Iterable)cpdTextBlocks).transform((Function)new CpdTextBlockToBlock(file.getKey())).toList();
            LOGGER.trace("Found {} duplicated cpd blocks on file {}", (Object)duplicatedBlocks.size(), (Object)file.getKey());
            LoadCrossProjectDuplicationsRepositoryStep.this.integrateCrossProjectDuplications.computeCpd(file, (Collection<Block>)originBlocks, (Collection<Block>)duplicatedBlocks);
        }

        private List<DuplicationUnitDto> selectDuplicates(Component file, Collection<String> hashes) {
            try (DbSession dbSession = LoadCrossProjectDuplicationsRepositoryStep.this.dbClient.openSession(false);){
                Analysis projectAnalysis = LoadCrossProjectDuplicationsRepositoryStep.this.analysisMetadataHolder.getBaseAnalysis();
                String analysisUuid = projectAnalysis == null ? null : projectAnalysis.getUuid();
                List list = LoadCrossProjectDuplicationsRepositoryStep.this.dbClient.duplicationDao().selectCandidates(dbSession, analysisUuid, file.getFileAttributes().getLanguageKey(), hashes);
                return list;
            }
        }
    }
}

