/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.formula.Counter;
import org.sonar.server.computation.task.projectanalysis.formula.CounterInitializationContext;
import org.sonar.server.computation.task.projectanalysis.formula.CreateMeasureContext;
import org.sonar.server.computation.task.projectanalysis.formula.Formula;
import org.sonar.server.computation.task.projectanalysis.formula.FormulaExecutorComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.step.ComputationStep;

public class LanguageDistributionMeasuresStep
implements ComputationStep {
    private static final String UNKNOWN_LANGUAGE_KEY = "<null>";
    private static final ImmutableList<Formula> FORMULAS = ImmutableList.of((Object)new LanguageDistributionFormula());
    private static final String[] LANGUAGE_DISTRIBUTION_FORMULA_METRICS = new String[]{"ncloc_language_distribution"};
    private final TreeRootHolder treeRootHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;

    public LanguageDistributionMeasuresStep(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository) {
        this.treeRootHolder = treeRootHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
    }

    @Override
    public void execute() {
        new PathAwareCrawler<FormulaExecutorComponentVisitor.Counters>(FormulaExecutorComponentVisitor.newBuilder(this.metricRepository, this.measureRepository).buildFor((Iterable<Formula>)FORMULAS)).visit(this.treeRootHolder.getRoot());
    }

    @Override
    public String getDescription() {
        return "Compute language distribution";
    }

    private static class LanguageDistributionCounter
    implements Counter<LanguageDistributionCounter> {
        private final Multiset<String> multiset = TreeMultiset.create();

        private LanguageDistributionCounter() {
        }

        @Override
        public void aggregate(LanguageDistributionCounter counter) {
            this.multiset.addAll(counter.multiset);
        }

        @Override
        public void initialize(CounterInitializationContext context) {
            if (context.getLeaf().getType() == Component.Type.FILE) {
                this.initializeForFile(context);
            }
            this.initializeForOtherLeaf(context);
        }

        private void initializeForFile(CounterInitializationContext context) {
            String language = context.getLeaf().getFileAttributes().getLanguageKey();
            Optional<Measure> ncloc = context.getMeasure("ncloc");
            if (ncloc.isPresent()) {
                this.multiset.add((Object)(language == null ? LanguageDistributionMeasuresStep.UNKNOWN_LANGUAGE_KEY : language), ((Measure)ncloc.get()).getIntValue());
            }
        }

        private void initializeForOtherLeaf(CounterInitializationContext context) {
            Optional<Measure> measure = context.getMeasure("ncloc_language_distribution");
            if (measure.isPresent()) {
                Map parse = KeyValueFormat.parse((String)((Measure)measure.get()).getData(), (KeyValueFormat.Converter)KeyValueFormat.newStringConverter(), (KeyValueFormat.Converter)KeyValueFormat.newIntegerConverter());
                for (Map.Entry entry : parse.entrySet()) {
                    this.multiset.add(entry.getKey(), ((Integer)entry.getValue()).intValue());
                }
            }
        }
    }

    private static class LanguageToTotalCount
    implements Function<String, Integer> {
        private final Multiset<String> multiset;

        public LanguageToTotalCount(Multiset<String> multiset) {
            this.multiset = multiset;
        }

        @Nullable
        public Integer apply(@Nonnull String language) {
            return this.multiset.count((Object)language);
        }
    }

    private static class LanguageDistributionFormula
    implements Formula<LanguageDistributionCounter> {
        private LanguageDistributionFormula() {
        }

        @Override
        public LanguageDistributionCounter createNewCounter() {
            return new LanguageDistributionCounter();
        }

        @Override
        public Optional<Measure> createMeasure(LanguageDistributionCounter counter, CreateMeasureContext context) {
            if (counter.multiset.isEmpty()) {
                return Optional.absent();
            }
            return Optional.of((Object)Measure.newMeasureBuilder().create(KeyValueFormat.format((Map)Maps.asMap((Set)counter.multiset.elementSet(), (Function)new LanguageToTotalCount((Multiset<String>)counter.multiset)))));
        }

        @Override
        public String[] getOutputMetricKeys() {
            return LANGUAGE_DISTRIBUTION_FORMULA_METRICS;
        }
    }
}

