/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.scm;

import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.server.computation.task.projectanalysis.batch.BatchReportReader;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.scm.Changeset;
import org.sonar.server.computation.task.projectanalysis.scm.ReportScmInfo;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfo;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfoDbLoader;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfoRepository;

public class ScmInfoRepositoryImpl
implements ScmInfoRepository {
    private static final Logger LOGGER = Loggers.get(ScmInfoRepositoryImpl.class);
    private final BatchReportReader batchReportReader;
    private final Map<Component, ScmInfo> scmInfoCache = new HashMap<Component, ScmInfo>();
    private final ScmInfoDbLoader scmInfoDbLoader;

    public ScmInfoRepositoryImpl(BatchReportReader batchReportReader, ScmInfoDbLoader scmInfoDbLoader) {
        this.batchReportReader = batchReportReader;
        this.scmInfoDbLoader = scmInfoDbLoader;
    }

    @Override
    public Optional<ScmInfo> getScmInfo(Component component) {
        Objects.requireNonNull(component, "Component cannot be null");
        return this.initializeScmInfoForComponent(component);
    }

    private Optional<ScmInfo> initializeScmInfoForComponent(Component component) {
        if (component.getType() != Component.Type.FILE) {
            return Optional.absent();
        }
        ScmInfo scmInfo = this.scmInfoCache.get(component);
        if (scmInfo != null) {
            return ScmInfoRepositoryImpl.optionalOf(scmInfo);
        }
        scmInfo = this.getScmInfoForComponent(component);
        this.scmInfoCache.put(component, scmInfo);
        return ScmInfoRepositoryImpl.optionalOf(scmInfo);
    }

    private static Optional<ScmInfo> optionalOf(ScmInfo scmInfo) {
        if (scmInfo == NoScmInfo.INSTANCE) {
            return Optional.absent();
        }
        return Optional.of((Object)scmInfo);
    }

    private ScmInfo getScmInfoForComponent(Component component) {
        ScannerReport.Changesets changesets = this.batchReportReader.readChangesets(component.getReportAttributes().getRef());
        if (changesets == null) {
            LOGGER.trace("No SCM info for file '{}'", (Object)component.getKey());
            return NoScmInfo.INSTANCE;
        }
        if (changesets.getCopyFromPrevious()) {
            return this.scmInfoDbLoader.getScmInfoFromDb(component);
        }
        return ScmInfoRepositoryImpl.getScmInfoFromReport(component, changesets);
    }

    private static ScmInfo getScmInfoFromReport(Component file, ScannerReport.Changesets changesets) {
        LOGGER.trace("Reading SCM info from report for file '{}'", (Object)file.getKey());
        return new ReportScmInfo(changesets);
    }

    static enum NoScmInfo implements ScmInfo
    {
        INSTANCE{

            @Override
            public Changeset getLatestChangeset() {
                return (Changeset)this.notImplemented();
            }

            @Override
            public Changeset getChangesetForLine(int lineNumber) {
                return (Changeset)this.notImplemented();
            }

            @Override
            public boolean hasChangesetForLine(int lineNumber) {
                return (Boolean)this.notImplemented();
            }

            @Override
            public Iterable<Changeset> getAllChangesets() {
                return (Iterable)this.notImplemented();
            }

            private <T> T notImplemented() {
                throw new UnsupportedOperationException("NoScmInfo does not implement any method");
            }
        };

    }
}

