/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.metric;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricImpl;

enum MetricDtoToMetric implements Function<MetricDto, Metric>
{
    INSTANCE;

    private static final int DEFAULT_DECIMAL_SCALE = 1;

    @Nonnull
    public Metric apply(@Nonnull MetricDto metricDto) {
        Metric.MetricType metricType = Metric.MetricType.valueOf(metricDto.getValueType());
        Integer decimalScale = null;
        if (metricType.getValueType() == Measure.ValueType.DOUBLE) {
            decimalScale = (Integer)MoreObjects.firstNonNull((Object)metricDto.getDecimalScale(), (Object)1);
        }
        return new MetricImpl(metricDto.getId(), metricDto.getKey(), metricDto.getShortName(), metricType, decimalScale, metricDto.getBestValue(), metricDto.isOptimizedBestValue());
    }
}

