/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.measure;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang.math.NumberUtils;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;

public class BestValueOptimization
implements Predicate<Measure> {
    private final Metric metric;

    private BestValueOptimization(Metric metric) {
        this.metric = Objects.requireNonNull(metric);
    }

    public static Predicate<Measure> from(Metric metric, Component component) {
        if (BestValueOptimization.isBestValueOptimized(metric) && BestValueOptimization.isBestValueOptimized(component)) {
            return new BestValueOptimization(metric);
        }
        return Predicates.alwaysFalse();
    }

    private static boolean isBestValueOptimized(Metric metric) {
        return metric.isBestValueOptimized();
    }

    private static boolean isBestValueOptimized(Component component) {
        return component.getType() == Component.Type.FILE;
    }

    public boolean apply(@Nonnull Measure measure) {
        return this.isBestValueOptimized(measure);
    }

    private boolean isBestValueOptimized(Measure measure) {
        return measure.getData() == null && !measure.hasQualityGateStatus() && BestValueOptimization.hasNoVariation(measure, this.metric.getBestValue()) && (measure.getValueType() == Measure.ValueType.NO_VALUE || BestValueOptimization.isBestValue(measure, this.metric.getBestValue()));
    }

    private static boolean hasNoVariation(Measure measure, Double bestValue) {
        return !measure.hasVariation() || BestValueOptimization.isVariationEmptyOrBestValue(measure.getVariation(), bestValue);
    }

    private static boolean isVariationEmptyOrBestValue(double variation, Double bestValue) {
        return NumberUtils.compare((double)variation, (double)0.0) == 0 || NumberUtils.compare((double)variation, (double)bestValue) == 0;
    }

    private static boolean isBestValue(Measure measure, Double bestValue) {
        switch (measure.getValueType()) {
            case BOOLEAN: {
                return bestValue.intValue() == 1 ? measure.getBooleanValue() : !measure.getBooleanValue();
            }
            case INT: {
                return bestValue.intValue() == measure.getIntValue();
            }
            case LONG: {
                return bestValue.longValue() == measure.getLongValue();
            }
            case DOUBLE: {
                return bestValue.compareTo(measure.getDoubleValue()) == 0;
            }
        }
        return false;
    }
}

