/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.formula;

import com.google.common.base.Optional;
import java.util.Objects;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.formula.Counter;
import org.sonar.server.computation.task.projectanalysis.formula.CounterInitializationContext;
import org.sonar.server.computation.task.projectanalysis.formula.CreateMeasureContext;
import org.sonar.server.computation.task.projectanalysis.formula.Formula;
import org.sonar.server.computation.task.projectanalysis.formula.counter.DoubleValue;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;

public class VariationSumFormula
implements Formula<VariationSumCounter> {
    private final String metricKey;

    public VariationSumFormula(String metricKey) {
        this.metricKey = Objects.requireNonNull(metricKey, "Metric key cannot be null");
    }

    @Override
    public VariationSumCounter createNewCounter() {
        return new VariationSumCounter(this.metricKey);
    }

    @Override
    public Optional<Measure> createMeasure(VariationSumCounter counter, CreateMeasureContext context) {
        if (!CrawlerDepthLimit.LEAVES.isDeeperThan(context.getComponent().getType()) || !counter.doubleValue.isSet()) {
            return Optional.absent();
        }
        return Optional.of((Object)Measure.newMeasureBuilder().setVariation(counter.doubleValue.getValue()).createNoValue());
    }

    @Override
    public String[] getOutputMetricKeys() {
        return new String[]{this.metricKey};
    }

    public static final class VariationSumCounter
    implements Counter<VariationSumCounter> {
        private final DoubleValue doubleValue = new DoubleValue();
        private final String metricKey;

        private VariationSumCounter(String metricKey) {
            this.metricKey = metricKey;
        }

        @Override
        public void aggregate(VariationSumCounter counter) {
            this.doubleValue.increment(counter.doubleValue);
        }

        @Override
        public void initialize(CounterInitializationContext context) {
            Optional<Measure> measure = context.getMeasure(this.metricKey);
            if (!measure.isPresent() || !((Measure)measure.get()).hasVariation()) {
                return;
            }
            double variation = ((Measure)measure.get()).getVariation();
            this.doubleValue.increment(variation);
        }
    }
}

