/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.batch;

import com.google.common.base.Throwables;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.sonar.core.util.CloseableIterator;
import org.sonar.core.util.LineReaderIterator;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportReader;
import org.sonar.server.computation.task.projectanalysis.batch.BatchReportDirectoryHolder;
import org.sonar.server.computation.task.projectanalysis.batch.BatchReportReader;

public class BatchReportReaderImpl
implements BatchReportReader {
    private final BatchReportDirectoryHolder batchReportDirectoryHolder;
    private ScannerReportReader delegate;
    private ScannerReport.Metadata metadata;

    public BatchReportReaderImpl(BatchReportDirectoryHolder batchReportDirectoryHolder) {
        this.batchReportDirectoryHolder = batchReportDirectoryHolder;
    }

    private void ensureInitialized() {
        if (this.delegate == null) {
            this.delegate = new ScannerReportReader(this.batchReportDirectoryHolder.getDirectory());
        }
    }

    @Override
    public ScannerReport.Metadata readMetadata() {
        this.ensureInitialized();
        if (this.metadata == null) {
            this.metadata = this.delegate.readMetadata();
        }
        return this.metadata;
    }

    @Override
    public CloseableIterator<String> readScannerLogs() {
        this.ensureInitialized();
        File file = this.delegate.getFileStructure().analysisLog();
        if (!file.exists()) {
            return CloseableIterator.emptyCloseableIterator();
        }
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)FileUtils.openInputStream((File)file), StandardCharsets.UTF_8);
            return new LineReaderIterator((Reader)reader);
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to open file " + file, e);
        }
    }

    @Override
    public CloseableIterator<ScannerReport.ActiveRule> readActiveRules() {
        this.ensureInitialized();
        return this.delegate.readActiveRules();
    }

    @Override
    public CloseableIterator<ScannerReport.Measure> readComponentMeasures(int componentRef) {
        this.ensureInitialized();
        return this.delegate.readComponentMeasures(componentRef);
    }

    @Override
    @CheckForNull
    public ScannerReport.Changesets readChangesets(int componentRef) {
        this.ensureInitialized();
        return this.delegate.readChangesets(componentRef);
    }

    @Override
    public ScannerReport.Component readComponent(int componentRef) {
        this.ensureInitialized();
        return this.delegate.readComponent(componentRef);
    }

    @Override
    public CloseableIterator<ScannerReport.Issue> readComponentIssues(int componentRef) {
        this.ensureInitialized();
        return this.delegate.readComponentIssues(componentRef);
    }

    @Override
    public CloseableIterator<ScannerReport.Duplication> readComponentDuplications(int componentRef) {
        this.ensureInitialized();
        return this.delegate.readComponentDuplications(componentRef);
    }

    @Override
    public CloseableIterator<ScannerReport.CpdTextBlock> readCpdTextBlocks(int componentRef) {
        this.ensureInitialized();
        return this.delegate.readCpdTextBlocks(componentRef);
    }

    @Override
    public CloseableIterator<ScannerReport.Symbol> readComponentSymbols(int componentRef) {
        this.ensureInitialized();
        return this.delegate.readComponentSymbols(componentRef);
    }

    @Override
    public CloseableIterator<ScannerReport.SyntaxHighlightingRule> readComponentSyntaxHighlighting(int fileRef) {
        this.ensureInitialized();
        return this.delegate.readComponentSyntaxHighlighting(fileRef);
    }

    @Override
    public CloseableIterator<ScannerReport.LineCoverage> readComponentCoverage(int fileRef) {
        this.ensureInitialized();
        return this.delegate.readComponentCoverage(fileRef);
    }

    @Override
    public Optional<CloseableIterator<String>> readFileSource(int fileRef) {
        this.ensureInitialized();
        File file = this.delegate.readFileSource(fileRef);
        if (file == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(new CloseableLineIterator(IOUtils.lineIterator((InputStream)FileUtils.openInputStream((File)file), (Charset)StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to traverse file: " + file, e);
        }
    }

    @Override
    public CloseableIterator<ScannerReport.Test> readTests(int testFileRef) {
        this.ensureInitialized();
        File file = this.delegate.readTests(testFileRef);
        if (file == null) {
            return CloseableIterator.emptyCloseableIterator();
        }
        try {
            return new ParserCloseableIterator<ScannerReport.Test>(ScannerReport.Test.parser(), FileUtils.openInputStream((File)file));
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
            return CloseableIterator.emptyCloseableIterator();
        }
    }

    @Override
    public CloseableIterator<ScannerReport.CoverageDetail> readCoverageDetails(int testFileRef) {
        this.ensureInitialized();
        File file = this.delegate.readCoverageDetails(testFileRef);
        if (file == null) {
            return CloseableIterator.emptyCloseableIterator();
        }
        try {
            return new ParserCloseableIterator<ScannerReport.CoverageDetail>(ScannerReport.CoverageDetail.parser(), FileUtils.openInputStream((File)file));
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
            return CloseableIterator.emptyCloseableIterator();
        }
    }

    @Override
    public CloseableIterator<ScannerReport.ContextProperty> readContextProperties() {
        this.ensureInitialized();
        return this.delegate.readContextProperties();
    }

    private static class ParserCloseableIterator<T>
    extends CloseableIterator<T> {
        private final Parser<T> parser;
        private final FileInputStream fileInputStream;

        public ParserCloseableIterator(Parser<T> parser, FileInputStream fileInputStream) {
            this.parser = parser;
            this.fileInputStream = fileInputStream;
        }

        protected T doNext() {
            try {
                return (T)this.parser.parseDelimitedFrom((InputStream)this.fileInputStream);
            }
            catch (InvalidProtocolBufferException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        }

        protected void doClose() throws Exception {
            this.fileInputStream.close();
        }
    }

    private static class CloseableLineIterator
    extends CloseableIterator<String> {
        private final LineIterator lineIterator;

        public CloseableLineIterator(LineIterator lineIterator) {
            this.lineIterator = lineIterator;
        }

        public boolean hasNext() {
            return this.lineIterator.hasNext();
        }

        public String next() {
            return this.lineIterator.next();
        }

        protected String doNext() {
            throw new NoSuchElementException("Empty closeable Iterator has no element");
        }

        protected void doClose() throws Exception {
            this.lineIterator.close();
        }
    }
}

