/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.ws;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.api.i18n.I18n;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Paging;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentTreeQuery;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.component.ws.ComponentDtoToWsComponent;
import org.sonar.server.component.ws.ComponentsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsParameterBuilder;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsComponents;
import org.sonarqube.ws.client.component.TreeWsRequest;

public class TreeAction
implements ComponentsWsAction {
    private static final int MAX_SIZE = 500;
    private static final int QUERY_MINIMUM_LENGTH = 3;
    private static final String ALL_STRATEGY = "all";
    private static final String CHILDREN_STRATEGY = "children";
    private static final String LEAVES_STRATEGY = "leaves";
    private static final Map<String, ComponentTreeQuery.Strategy> STRATEGIES = ImmutableMap.of((Object)"all", (Object)ComponentTreeQuery.Strategy.LEAVES, (Object)"children", (Object)ComponentTreeQuery.Strategy.CHILDREN, (Object)"leaves", (Object)ComponentTreeQuery.Strategy.LEAVES);
    private static final String NAME_SORT = "name";
    private static final String PATH_SORT = "path";
    private static final String QUALIFIER_SORT = "qualifier";
    private static final Set<String> SORTS = ImmutableSortedSet.of((Comparable)((Object)"name"), (Comparable)((Object)"path"), (Comparable)((Object)"qualifier"));
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final ResourceTypes resourceTypes;
    private final UserSession userSession;
    private final I18n i18n;

    public TreeAction(DbClient dbClient, ComponentFinder componentFinder, ResourceTypes resourceTypes, UserSession userSession, I18n i18n) {
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.resourceTypes = resourceTypes;
        this.userSession = userSession;
        this.i18n = i18n;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("tree").setDescription(String.format("Navigate through components based on the chosen strategy. The %s or the %s parameter must be provided.<br>Requires the following permission: 'Browse' on the specified project.<br>When limiting search with the %s parameter, directories are not returned.", "componentId", "component", "q")).setSince("5.4").setResponseExample(this.getClass().getResource("tree-example.json")).setChangelog(new Change[]{new Change("6.4", "The field 'id' is deprecated in the response")}).setHandler((RequestHandler)this).addPagingParams(100, 500);
        action.createParam("componentId").setDescription("Base component id. The search is based on this component.").setDeprecatedKey("baseComponentId", "6.4").setDeprecatedSince("6.4").setExampleValue((Object)"AU-TpxcA-iU5OvuD2FLz");
        action.createParam("component").setDescription("Base component key. The search is based on this component.").setDeprecatedKey("baseComponentKey", "6.4").setExampleValue((Object)"my_project");
        action.createParam("branch").setDescription("Branch key").setExampleValue((Object)"feature/my_branch").setInternal(true).setSince("6.6");
        action.createSortParams(SORTS, (Object)NAME_SORT, true).setDescription("Comma-separated list of sort fields").setExampleValue((Object)"name, path");
        action.createParam("q").setDescription(String.format("Limit search to: <ul><li>component names that contain the supplied string</li><li>component keys that are exactly the same as the supplied string</li></ul>Must have at least %d characters", 3)).setExampleValue((Object)"FILE_NAM");
        WsParameterBuilder.createQualifiersParameter(action, WsParameterBuilder.QualifierParameterContext.newQualifierParameterContext(this.i18n, this.resourceTypes));
        action.createParam("strategy").setDescription("Strategy to search for base component descendants:<ul><li>children: return the children components of the base component. Grandchildren components are not returned</li><li>all: return all the descendants components of the base component. Grandchildren are returned.</li><li>leaves: return all the descendant components (files, in general) which don't have other children. They are the leaves of the component tree.</li></ul>").setPossibleValues(STRATEGIES.keySet()).setDefaultValue((Object)ALL_STRATEGY);
    }

    public void handle(Request request, Response response) throws Exception {
        WsComponents.TreeWsResponse treeWsResponse = this.doHandle(TreeAction.toTreeWsRequest(request));
        WsUtils.writeProtobuf((Message)treeWsResponse, request, response);
    }

    private WsComponents.TreeWsResponse doHandle(TreeWsRequest treeWsRequest) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto baseComponent = this.loadComponent(dbSession, treeWsRequest);
            this.checkPermissions(baseComponent);
            OrganizationDto organizationDto = this.componentFinder.getOrganization(dbSession, baseComponent);
            ComponentTreeQuery query = this.toComponentTreeQuery(treeWsRequest, baseComponent);
            List<ComponentDto> components = this.dbClient.componentDao().selectDescendants(dbSession, query);
            int total = components.size();
            components = TreeAction.sortComponents(components, treeWsRequest);
            components = TreeAction.paginateComponents(components, treeWsRequest);
            Map<String, ComponentDto> referenceComponentsByUuid = this.searchReferenceComponentsByUuid(dbSession, components);
            WsComponents.TreeWsResponse treeWsResponse = TreeAction.buildResponse(baseComponent, organizationDto, components, referenceComponentsByUuid, Paging.forPageIndex((int)treeWsRequest.getPage()).withPageSize(treeWsRequest.getPageSize().intValue()).andTotal(total));
            return treeWsResponse;
        }
    }

    private ComponentDto loadComponent(DbSession dbSession, TreeWsRequest request) {
        String componentId = request.getBaseComponentId();
        String componentKey = request.getBaseComponentKey();
        String branch = request.getBranch();
        Preconditions.checkArgument((componentId == null || branch == null ? 1 : 0) != 0, (String)"'%s' and '%s' parameters cannot be used at the same time", (Object[])new Object[]{"componentId", "branch"});
        return branch == null ? this.componentFinder.getByUuidOrKey(dbSession, componentId, componentKey, ComponentFinder.ParamNames.COMPONENT_ID_AND_COMPONENT) : this.componentFinder.getByKeyAndBranch(dbSession, componentKey, branch);
    }

    private Map<String, ComponentDto> searchReferenceComponentsByUuid(DbSession dbSession, List<ComponentDto> components) {
        List referenceComponentIds = (List)components.stream().map(ComponentDto::getCopyResourceUuid).filter(Objects::nonNull).collect(MoreCollectors.toList());
        if (referenceComponentIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return (Map)this.dbClient.componentDao().selectByUuids(dbSession, (Collection)referenceComponentIds).stream().collect(MoreCollectors.uniqueIndex(ComponentDto::uuid));
    }

    private void checkPermissions(ComponentDto baseComponent) {
        this.userSession.checkComponentPermission("user", baseComponent);
    }

    private static WsComponents.TreeWsResponse buildResponse(ComponentDto baseComponent, OrganizationDto organizationDto, List<ComponentDto> components, Map<String, ComponentDto> referenceComponentsByUuid, Paging paging) {
        WsComponents.TreeWsResponse.Builder response = WsComponents.TreeWsResponse.newBuilder();
        response.getPagingBuilder().setPageIndex(paging.pageIndex()).setPageSize(paging.pageSize()).setTotal(paging.total()).build();
        response.setBaseComponent(TreeAction.toWsComponent(baseComponent, organizationDto, referenceComponentsByUuid));
        for (ComponentDto dto : components) {
            response.addComponents(TreeAction.toWsComponent(dto, organizationDto, referenceComponentsByUuid));
        }
        return response.build();
    }

    private static WsComponents.Component.Builder toWsComponent(ComponentDto component, OrganizationDto organizationDto, Map<String, ComponentDto> referenceComponentsByUuid) {
        WsComponents.Component.Builder wsComponent = ComponentDtoToWsComponent.componentDtoToWsComponent(component, organizationDto, Optional.empty());
        ComponentDto referenceComponent = referenceComponentsByUuid.get(component.getCopyResourceUuid());
        if (referenceComponent != null) {
            wsComponent.setRefId(referenceComponent.uuid());
            wsComponent.setRefKey(referenceComponent.getDbKey());
        }
        return wsComponent;
    }

    private ComponentTreeQuery toComponentTreeQuery(TreeWsRequest request, ComponentDto baseComponent) {
        List<String> childrenQualifiers = this.childrenQualifiers(request, baseComponent.qualifier());
        ComponentTreeQuery.Builder query = ComponentTreeQuery.builder().setBaseUuid(baseComponent.uuid()).setStrategy(STRATEGIES.get(request.getStrategy()));
        if (request.getQuery() != null) {
            query.setNameOrKeyQuery(request.getQuery());
        }
        if (childrenQualifiers != null) {
            query.setQualifiers(childrenQualifiers);
        }
        return query.build();
    }

    @CheckForNull
    private List<String> childrenQualifiers(TreeWsRequest request, String baseQualifier) {
        List requestQualifiers = request.getQualifiers();
        List childrenQualifiers = null;
        if (LEAVES_STRATEGY.equals(request.getStrategy())) {
            childrenQualifiers = this.resourceTypes.getLeavesQualifiers(baseQualifier);
        }
        if (requestQualifiers == null) {
            return childrenQualifiers;
        }
        if (childrenQualifiers == null) {
            return requestQualifiers;
        }
        Sets.SetView qualifiersIntersection = Sets.intersection(new HashSet(childrenQualifiers), new HashSet(requestQualifiers));
        return new ArrayList<String>((Collection<String>)qualifiersIntersection);
    }

    private static TreeWsRequest toTreeWsRequest(Request request) {
        TreeWsRequest treeWsRequest = new TreeWsRequest().setBaseComponentId(request.param("componentId")).setBaseComponentKey(request.param("component")).setBranch(request.param("branch")).setStrategy(request.mandatoryParam("strategy")).setQuery(request.param("q")).setQualifiers(request.paramAsStrings("qualifiers")).setSort(request.mandatoryParamAsStrings("s")).setAsc(Boolean.valueOf(request.mandatoryParamAsBoolean("asc"))).setPage(Integer.valueOf(request.mandatoryParamAsInt("p"))).setPageSize(Integer.valueOf(request.mandatoryParamAsInt("ps")));
        WsUtils.checkRequest(treeWsRequest.getPageSize() <= 500, "The '%s' parameter must be less than %d", "ps", 500);
        String searchQuery = treeWsRequest.getQuery();
        WsUtils.checkRequest(searchQuery == null || searchQuery.length() >= 3, "The '%s' parameter must have at least %d characters", "q", 3);
        return treeWsRequest;
    }

    private static List<ComponentDto> paginateComponents(List<ComponentDto> components, TreeWsRequest wsRequest) {
        return FluentIterable.from(components).skip(Paging.offset((int)wsRequest.getPage(), (int)wsRequest.getPageSize())).limit(wsRequest.getPageSize().intValue()).toList();
    }

    public static List<ComponentDto> sortComponents(List<ComponentDto> components, TreeWsRequest wsRequest) {
        List sortParameters = wsRequest.getSort();
        if (sortParameters == null || sortParameters.isEmpty()) {
            return components;
        }
        boolean isAscending = wsRequest.getAsc();
        ImmutableMap orderingsBySortField = ImmutableMap.builder().put((Object)NAME_SORT, TreeAction.stringOrdering(isAscending, (Function<ComponentDto, String>)((Function)ComponentDto::name))).put((Object)QUALIFIER_SORT, TreeAction.stringOrdering(isAscending, (Function<ComponentDto, String>)((Function)ComponentDto::qualifier))).put((Object)PATH_SORT, TreeAction.stringOrdering(isAscending, (Function<ComponentDto, String>)((Function)ComponentDto::path))).build();
        String firstSortParameter = (String)sortParameters.get(0);
        Ordering primaryOrdering = (Ordering)orderingsBySortField.get(firstSortParameter);
        if (sortParameters.size() > 1) {
            for (int i = 1; i < sortParameters.size(); ++i) {
                String secondarySortParameter = (String)sortParameters.get(i);
                Ordering secondaryOrdering = (Ordering)orderingsBySortField.get(secondarySortParameter);
                primaryOrdering = primaryOrdering.compound((Comparator)secondaryOrdering);
            }
        }
        return primaryOrdering.immutableSortedCopy(components);
    }

    private static Ordering<ComponentDto> stringOrdering(boolean isAscending, Function<ComponentDto, String> function) {
        Ordering ordering = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER);
        if (!isAscending) {
            ordering = ordering.reverse();
        }
        return ordering.nullsLast().onResultOf(function);
    }
}

