/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.batch;

import com.google.protobuf.Message;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.scanner.protocol.input.FileData;
import org.sonar.scanner.protocol.input.ProjectRepositories;
import org.sonar.server.batch.BatchWsAction;
import org.sonar.server.batch.ProjectDataLoader;
import org.sonar.server.batch.ProjectDataQuery;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsBatch;

public class ProjectAction
implements BatchWsAction {
    private static final String PARAM_KEY = "key";
    private static final String PARAM_PROFILE = "profile";
    private static final String PARAM_ISSUES_MODE = "issues_mode";
    private static final String PARAM_BRANCH = "branch";
    private final ProjectDataLoader projectDataLoader;

    public ProjectAction(ProjectDataLoader projectDataLoader) {
        this.projectDataLoader = projectDataLoader;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("project").setDescription("Return project repository").setResponseExample(this.getClass().getResource("project-example.json")).setSince("4.5").setInternal(true).setHandler((RequestHandler)this);
        action.createParam(PARAM_KEY).setRequired(true).setDescription("Project or module key").setExampleValue((Object)"my_project");
        action.createParam(PARAM_PROFILE).setDescription("Profile name").setExampleValue((Object)"SonarQube Way");
        action.createParam(PARAM_ISSUES_MODE).setDescription("Issues mode or not").setDefaultValue((Object)false).setBooleanPossibleValues();
        action.createParam(PARAM_BRANCH).setSince("6.6").setDescription("Branch key").setExampleValue((Object)"feature/my_branch");
    }

    public void handle(Request wsRequest, Response wsResponse) throws Exception {
        ProjectRepositories data = this.projectDataLoader.load(ProjectDataQuery.create().setModuleKey(wsRequest.mandatoryParam(PARAM_KEY)).setProfileName(wsRequest.param(PARAM_PROFILE)).setIssuesMode(wsRequest.mandatoryParamAsBoolean(PARAM_ISSUES_MODE)).setBranch(wsRequest.param(PARAM_BRANCH)));
        WsBatch.WsProjectResponse projectResponse = ProjectAction.buildResponse(data);
        WsUtils.writeProtobuf((Message)projectResponse, wsRequest, wsResponse);
    }

    private static WsBatch.WsProjectResponse buildResponse(ProjectRepositories data) {
        WsBatch.WsProjectResponse.Builder response = WsBatch.WsProjectResponse.newBuilder();
        Protobuf.setNullable((Object)data.lastAnalysisDate(), arg_0 -> ((WsBatch.WsProjectResponse.Builder)response).setLastAnalysisDate(arg_0), Date::getTime);
        response.setTimestamp(data.timestamp());
        response.getMutableFileDataByModuleAndPath().putAll(ProjectAction.buildFileDataByModuleAndPath(data));
        response.getMutableSettingsByModule().putAll(ProjectAction.buildSettingsByModule(data));
        return response.build();
    }

    private static Map<String, WsBatch.WsProjectResponse.FileDataByPath> buildFileDataByModuleAndPath(ProjectRepositories data) {
        HashMap<String, WsBatch.WsProjectResponse.FileDataByPath> fileDataByModuleAndPathResponse = new HashMap<String, WsBatch.WsProjectResponse.FileDataByPath>();
        for (Map.Entry moduleAndFileDataByPathEntry : data.fileDataByModuleAndPath().entrySet()) {
            fileDataByModuleAndPathResponse.put((String)moduleAndFileDataByPathEntry.getKey(), ProjectAction.buildFileDataByPath((Map)moduleAndFileDataByPathEntry.getValue()));
        }
        return fileDataByModuleAndPathResponse;
    }

    private static WsBatch.WsProjectResponse.FileDataByPath buildFileDataByPath(Map<String, FileData> fileDataByPath) {
        WsBatch.WsProjectResponse.FileDataByPath.Builder response = WsBatch.WsProjectResponse.FileDataByPath.newBuilder();
        Map fileDataByPathResponse = response.getMutableFileDataByPath();
        for (Map.Entry<String, FileData> pathFileDataEntry : fileDataByPath.entrySet()) {
            fileDataByPathResponse.put(pathFileDataEntry.getKey(), ProjectAction.toFileDataResponse(pathFileDataEntry.getValue()));
        }
        return response.build();
    }

    private static Map<String, WsBatch.WsProjectResponse.Settings> buildSettingsByModule(ProjectRepositories data) {
        HashMap<String, WsBatch.WsProjectResponse.Settings> settingsByModuleResponse = new HashMap<String, WsBatch.WsProjectResponse.Settings>();
        for (Map.Entry moduleSettingsEntry : data.settings().entrySet()) {
            settingsByModuleResponse.put((String)moduleSettingsEntry.getKey(), ProjectAction.toSettingsResponse((Map)moduleSettingsEntry.getValue()));
        }
        return settingsByModuleResponse;
    }

    private static WsBatch.WsProjectResponse.Settings toSettingsResponse(Map<String, String> settings) {
        WsBatch.WsProjectResponse.Settings.Builder settingsResponse = WsBatch.WsProjectResponse.Settings.newBuilder();
        settingsResponse.getMutableSettings().putAll(settings);
        return settingsResponse.build();
    }

    private static WsBatch.WsProjectResponse.FileData toFileDataResponse(FileData fileData) {
        WsBatch.WsProjectResponse.FileData.Builder fileDataBuilder = WsBatch.WsProjectResponse.FileData.newBuilder();
        Protobuf.setNullable((Object)fileData.hash(), arg_0 -> ((WsBatch.WsProjectResponse.FileData.Builder)fileDataBuilder).setHash(arg_0));
        Protobuf.setNullable((Object)fileData.revision(), arg_0 -> ((WsBatch.WsProjectResponse.FileData.Builder)fileDataBuilder).setRevision(arg_0));
        return fileDataBuilder.build();
    }
}

